/*
 * Decompiled with CFR 0.152.
 */
package org.aussiebox.dfwaypoints.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import org.aussiebox.dfwaypoints.Dfwaypoints;

public class FileUtil {
    public static JsonObject loadJSONExternal(String folder, String fileName, boolean shouldCreateIfNotExist) {
        File file = new File(folder + File.separator + fileName);
        if (!file.exists()) {
            if (shouldCreateIfNotExist) {
                try {
                    if (file.getParentFile() != null && !file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    file.createNewFile();
                }
                catch (IOException e) {
                    Dfwaypoints.LOGGER.error("Failed to create {} empty file", (Object)fileName);
                }
            }
            return new JsonObject();
        }
        try {
            String jsonStr = new String(Files.readAllBytes(file.toPath()));
            return JsonParser.parseString((String)jsonStr).getAsJsonObject();
        }
        catch (Exception e) {
            Dfwaypoints.LOGGER.error("Failed to load {} (invalid format?)", (Object)fileName);
            return new JsonObject();
        }
    }

    public static JsonObject loadJSON(String filename) {
        return FileUtil.loadJSONExternal("Dfwaypoints", filename, true);
    }

    public static void saveJSON(String filename, JsonObject data) throws IOException {
        File file = new File("Dfwaypoints" + File.separator + filename);
        FileWriter fileWriter = new FileWriter(file);
        Dfwaypoints.LOGGER.info("Saving: {}", (Object)filename);
        fileWriter.write(data.toString());
        fileWriter.flush();
        fileWriter.close();
    }
}

