/*
 * Decompiled with CFR 0.152.
 */
package com.example.stackable;

import com.mojang.logging.LogUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="stackablemod")
public class StackableMod {
    public static final String MODID = "stackablemod";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<Item, Integer> STACKABLE_ITEMS = new HashMap<Item, Integer>();

    public StackableMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Initializing Stackable Items mod...");
        event.enqueueWork(this::modifyItemsMaxCount);
        LOGGER.info("Stackable Items mod initialized! Modified {} items.", (Object)STACKABLE_ITEMS.size());
    }

    public static Map<Item, Integer> getStackableItems() {
        return STACKABLE_ITEMS;
    }

    public static void addStackableItem(Item item, int maxCount) {
        STACKABLE_ITEMS.put(item, maxCount);
        StackableMod.modifyItemMaxCount(item, maxCount);
    }

    private void modifyItemsMaxCount() {
        for (Map.Entry<Item, Integer> entry : STACKABLE_ITEMS.entrySet()) {
            StackableMod.modifyItemMaxCount(entry.getKey(), entry.getValue());
        }
    }

    private static void modifyItemMaxCount(Item item, int maxCount) {
        try {
            Field maxStackSizeField = Item.class.getDeclaredField("maxStackSize");
            maxStackSizeField.setAccessible(true);
            maxStackSizeField.setInt(item, maxCount);
            LOGGER.info("Successfully modified {} max count to {} via reflection", (Object)item.toString(), (Object)maxCount);
        }
        catch (NoSuchFieldException e) {
            try {
                Field[] fields;
                for (Field field : fields = Item.class.getDeclaredFields()) {
                    if (field.getType() != Integer.TYPE) continue;
                    field.setAccessible(true);
                    int value = field.getInt(item);
                    if (value != 1 && value != 16 && value != 64) continue;
                    field.setInt(item, maxCount);
                    LOGGER.info("Successfully modified {} max count to {} via field: {}", new Object[]{item.toString(), maxCount, field.getName()});
                }
            }
            catch (Exception e2) {
                LOGGER.error("Failed to modify {} max count", (Object)item.toString(), (Object)e2);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to modify {} max count", (Object)item.toString(), (Object)e);
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        if (stack.getItem() != Items.POWDER_SNOW_BUCKET) {
            return;
        }
        LOGGER.info("Handling PowderSnowBucket right-click for stack size: {}", (Object)stack.getCount());
        BlockPos targetPos = pos.relative(event.getFace());
        if (world.getBlockState(targetPos).isAir() || world.getBlockState(targetPos).canBeReplaced()) {
            if (!world.isClientSide()) {
                world.setBlock(targetPos, Blocks.POWDER_SNOW.defaultBlockState(), 3);
                world.playSound(null, targetPos, SoundEvents.BUCKET_EMPTY_POWDER_SNOW, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
                LOGGER.info("Reduced PowderSnowBucket stack to: {}", (Object)stack.getCount());
                ItemStack emptyBucket = new ItemStack((ItemLike)Items.BUCKET, 1);
                if (!player.getInventory().add(emptyBucket)) {
                    player.drop(emptyBucket, false);
                    LOGGER.info("Dropped empty bucket as inventory is full");
                } else {
                    LOGGER.info("Added empty bucket to inventory");
                }
            }
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)world.isClientSide()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        Entity target = event.getTarget();
        Level world = event.getLevel();
        if (stack.getItem() != Items.WATER_BUCKET) {
            return;
        }
        Item fishBucketItem = null;
        if (target.getType().toString().contains("axolotl")) {
            fishBucketItem = Items.AXOLOTL_BUCKET;
        } else if (target.getType().toString().contains("tadpole")) {
            fishBucketItem = Items.TADPOLE_BUCKET;
        } else if (target instanceof Pufferfish) {
            fishBucketItem = Items.PUFFERFISH_BUCKET;
        } else if (target instanceof Cod) {
            fishBucketItem = Items.COD_BUCKET;
        } else if (target instanceof Salmon) {
            fishBucketItem = Items.SALMON_BUCKET;
        } else if (target instanceof TropicalFish) {
            fishBucketItem = Items.TROPICAL_FISH_BUCKET;
        }
        if (fishBucketItem == null) {
            return;
        }
        LOGGER.info("Handling fish bucket creation for: {}", (Object)fishBucketItem);
        if (!world.isClientSide()) {
            target.discard();
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
                ItemStack fishBucket = new ItemStack((ItemLike)fishBucketItem, 1);
                if (!player.getInventory().add(fishBucket)) {
                    player.drop(fishBucket, false);
                    LOGGER.info("Dropped fish bucket as inventory is full");
                } else {
                    LOGGER.info("Added fish bucket to inventory: {}", (Object)fishBucket);
                }
            }
            world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.BUCKET_FILL_FISH, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        event.setCancellationResult(InteractionResult.sidedSuccess((boolean)world.isClientSide()));
        event.setCanceled(true);
    }

    static {
        STACKABLE_ITEMS.put(Items.TOTEM_OF_UNDYING, 64);
        STACKABLE_ITEMS.put(Items.ENDER_PEARL, 64);
        STACKABLE_ITEMS.put(Items.EGG, 64);
        STACKABLE_ITEMS.put(Items.SNOWBALL, 64);
        STACKABLE_ITEMS.put(Items.ELYTRA, 16);
        STACKABLE_ITEMS.put(Items.CAKE, 16);
        STACKABLE_ITEMS.put(Items.MINECART, 16);
        STACKABLE_ITEMS.put(Items.CHEST_MINECART, 16);
        STACKABLE_ITEMS.put(Items.FURNACE_MINECART, 16);
        STACKABLE_ITEMS.put(Items.HOPPER_MINECART, 16);
        STACKABLE_ITEMS.put(Items.TNT_MINECART, 16);
        STACKABLE_ITEMS.put(Items.COMMAND_BLOCK_MINECART, 16);
        STACKABLE_ITEMS.put(Items.BUCKET, 64);
        STACKABLE_ITEMS.put(Items.PUFFERFISH_BUCKET, 64);
        STACKABLE_ITEMS.put(Items.AXOLOTL_BUCKET, 64);
        STACKABLE_ITEMS.put(Items.COD_BUCKET, 64);
        STACKABLE_ITEMS.put(Items.SALMON_BUCKET, 64);
        STACKABLE_ITEMS.put(Items.TADPOLE_BUCKET, 64);
        STACKABLE_ITEMS.put(Items.TROPICAL_FISH_BUCKET, 64);
        STACKABLE_ITEMS.put(Items.MILK_BUCKET, 64);
        STACKABLE_ITEMS.put(Items.LAVA_BUCKET, 64);
        STACKABLE_ITEMS.put(Items.WATER_BUCKET, 64);
        STACKABLE_ITEMS.put(Items.POWDER_SNOW_BUCKET, 64);
        STACKABLE_ITEMS.put(Items.SADDLE, 16);
        STACKABLE_ITEMS.put(Items.LEATHER_HORSE_ARMOR, 16);
        STACKABLE_ITEMS.put(Items.IRON_HORSE_ARMOR, 16);
        STACKABLE_ITEMS.put(Items.GOLDEN_HORSE_ARMOR, 16);
        STACKABLE_ITEMS.put(Items.DIAMOND_HORSE_ARMOR, 16);
        STACKABLE_ITEMS.put(Items.WHITE_BED, 64);
        STACKABLE_ITEMS.put(Items.GRAY_BED, 64);
        STACKABLE_ITEMS.put(Items.LIGHT_GRAY_BED, 64);
        STACKABLE_ITEMS.put(Items.BLACK_BED, 64);
        STACKABLE_ITEMS.put(Items.BROWN_BED, 64);
        STACKABLE_ITEMS.put(Items.RED_BED, 64);
        STACKABLE_ITEMS.put(Items.ORANGE_BED, 64);
        STACKABLE_ITEMS.put(Items.YELLOW_BED, 64);
        STACKABLE_ITEMS.put(Items.GREEN_BED, 64);
        STACKABLE_ITEMS.put(Items.LIME_BED, 64);
        STACKABLE_ITEMS.put(Items.CYAN_BED, 64);
        STACKABLE_ITEMS.put(Items.BLUE_BED, 64);
        STACKABLE_ITEMS.put(Items.LIGHT_BLUE_BED, 64);
        STACKABLE_ITEMS.put(Items.MAGENTA_BED, 64);
        STACKABLE_ITEMS.put(Items.PINK_BED, 64);
        STACKABLE_ITEMS.put(Items.PURPLE_BED, 64);
        STACKABLE_ITEMS.put(Items.WHITE_BANNER, 64);
        STACKABLE_ITEMS.put(Items.GRAY_BANNER, 64);
        STACKABLE_ITEMS.put(Items.LIGHT_GRAY_BANNER, 64);
        STACKABLE_ITEMS.put(Items.BLACK_BANNER, 64);
        STACKABLE_ITEMS.put(Items.BROWN_BANNER, 64);
        STACKABLE_ITEMS.put(Items.RED_BANNER, 64);
        STACKABLE_ITEMS.put(Items.ORANGE_BANNER, 64);
        STACKABLE_ITEMS.put(Items.YELLOW_BANNER, 64);
        STACKABLE_ITEMS.put(Items.GREEN_BANNER, 64);
        STACKABLE_ITEMS.put(Items.LIME_BANNER, 64);
        STACKABLE_ITEMS.put(Items.CYAN_BANNER, 64);
        STACKABLE_ITEMS.put(Items.BLUE_BANNER, 64);
        STACKABLE_ITEMS.put(Items.LIGHT_BLUE_BANNER, 64);
        STACKABLE_ITEMS.put(Items.MAGENTA_BANNER, 64);
        STACKABLE_ITEMS.put(Items.PINK_BANNER, 64);
        STACKABLE_ITEMS.put(Items.PURPLE_BANNER, 64);
        STACKABLE_ITEMS.put(Items.OAK_BOAT, 16);
        STACKABLE_ITEMS.put(Items.SPRUCE_BOAT, 16);
        STACKABLE_ITEMS.put(Items.BIRCH_BOAT, 16);
        STACKABLE_ITEMS.put(Items.JUNGLE_BOAT, 16);
        STACKABLE_ITEMS.put(Items.ACACIA_BOAT, 16);
        STACKABLE_ITEMS.put(Items.DARK_OAK_BOAT, 16);
        STACKABLE_ITEMS.put(Items.MANGROVE_BOAT, 16);
        STACKABLE_ITEMS.put(Items.CHERRY_BOAT, 16);
        STACKABLE_ITEMS.put(Items.BAMBOO_RAFT, 16);
        STACKABLE_ITEMS.put(Items.OAK_CHEST_BOAT, 16);
        STACKABLE_ITEMS.put(Items.SPRUCE_CHEST_BOAT, 16);
        STACKABLE_ITEMS.put(Items.BIRCH_CHEST_BOAT, 16);
        STACKABLE_ITEMS.put(Items.JUNGLE_CHEST_BOAT, 16);
        STACKABLE_ITEMS.put(Items.ACACIA_CHEST_BOAT, 16);
        STACKABLE_ITEMS.put(Items.DARK_OAK_CHEST_BOAT, 16);
        STACKABLE_ITEMS.put(Items.MANGROVE_CHEST_BOAT, 16);
        STACKABLE_ITEMS.put(Items.CHERRY_CHEST_BOAT, 16);
        STACKABLE_ITEMS.put(Items.BAMBOO_CHEST_RAFT, 16);
        STACKABLE_ITEMS.put(Items.POTION, 64);
        STACKABLE_ITEMS.put(Items.LINGERING_POTION, 64);
        STACKABLE_ITEMS.put(Items.SPLASH_POTION, 64);
    }
}

