/*
 * Decompiled with CFR 0.152.
 */
package com.example.stackable.mixins;

import com.example.stackable.StackableMod;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public class ItemStackMixin {
    @Inject(method={"getMaxStackSize"}, at={@At(value="HEAD")}, cancellable=true)
    private void makeItemsStackableInStack(CallbackInfoReturnable<Integer> cir) {
        ItemStack stack = (ItemStack)this;
        if (StackableMod.getStackableItems().containsKey(stack.getItem())) {
            int newMaxCount = StackableMod.getStackableItems().get(stack.getItem());
            cir.setReturnValue((Object)newMaxCount);
        }
    }

    @Inject(method={"isStackable"}, at={@At(value="HEAD")}, cancellable=true)
    private void makeItemsStackableCheck(CallbackInfoReturnable<Boolean> cir) {
        ItemStack stack = (ItemStack)this;
        if (StackableMod.getStackableItems().containsKey(stack.getItem())) {
            cir.setReturnValue((Object)true);
        }
    }
}

