/*
 * Decompiled with CFR 0.152.
 */
package com.example.stackable.mixins;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MilkBucketItem.class})
public class MilkBucketMixin {
    @Inject(method={"finishUsingItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void fixStackedMilkBucketUsage(ItemStack stack, Level world, LivingEntity user, CallbackInfoReturnable<ItemStack> cir) {
        if (user instanceof Player) {
            Player player = (Player)user;
            if (stack.getItem() == Items.MILK_BUCKET) {
                if (!world.isClientSide) {
                    player.removeAllEffects();
                }
                if (player.getAbilities().instabuild) {
                    cir.setReturnValue((Object)stack);
                    return;
                }
                if (stack.getCount() > 1) {
                    stack.shrink(1);
                    ItemStack emptyBucket = new ItemStack((ItemLike)Items.BUCKET);
                    if (!player.getInventory().add(emptyBucket)) {
                        player.drop(emptyBucket, false);
                    }
                    cir.setReturnValue((Object)stack);
                } else {
                    cir.setReturnValue((Object)new ItemStack((ItemLike)Items.BUCKET));
                }
            }
        }
    }
}

