/*
 * Decompiled with CFR 0.152.
 */
package com.example.stackable;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackableTotem
implements ModInitializer {
    public static final String MOD_ID = "stackable-totem";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"stackable-totem");
    private static final Map<class_1792, Integer> STACKABLE_ITEMS = new HashMap<class_1792, Integer>();

    public void onInitialize() {
        LOGGER.info("Initializing Stackable Items mod...");
        this.modifyItemsMaxCount();
        ServerLifecycleEvents.SERVER_STARTING.register(server -> this.modifyItemsMaxCount());
        LOGGER.info("Stackable Items mod initialized! Modified {} items.", (Object)STACKABLE_ITEMS.size());
    }

    public static Map<class_1792, Integer> getStackableItems() {
        return STACKABLE_ITEMS;
    }

    public static void addStackableItem(class_1792 item, int maxCount) {
        STACKABLE_ITEMS.put(item, maxCount);
        StackableTotem.modifyItemMaxCount(item, maxCount);
    }

    private void modifyItemsMaxCount() {
        for (Map.Entry<class_1792, Integer> entry : STACKABLE_ITEMS.entrySet()) {
            StackableTotem.modifyItemMaxCount(entry.getKey(), entry.getValue());
        }
    }

    private static void modifyItemMaxCount(class_1792 item, int newMaxCount) {
        try {
            Field maxCountField = class_1792.class.getDeclaredField("maxCount");
            maxCountField.setAccessible(true);
            maxCountField.setInt(item, newMaxCount);
            LOGGER.info("Successfully modified {} max count to {} via reflection", (Object)item.toString(), (Object)newMaxCount);
        }
        catch (NoSuchFieldException e) {
            try {
                Field[] fields;
                for (Field field : fields = class_1792.class.getDeclaredFields()) {
                    if (field.getType() != Integer.TYPE) continue;
                    field.setAccessible(true);
                    int value = field.getInt(item);
                    if (value != 1 && value != 16 && value != 64) continue;
                    field.setInt(item, newMaxCount);
                    LOGGER.info("Successfully modified {} max count to {} via field: {}", new Object[]{item.toString(), newMaxCount, field.getName()});
                }
            }
            catch (Exception e2) {
                LOGGER.error("Failed to modify {} max count", (Object)item.toString(), (Object)e2);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to modify {} max count", (Object)item.toString(), (Object)e);
        }
    }

    static {
        STACKABLE_ITEMS.put(class_1802.field_8288, 64);
        STACKABLE_ITEMS.put(class_1802.field_8634, 64);
        STACKABLE_ITEMS.put(class_1802.field_8803, 64);
        STACKABLE_ITEMS.put(class_1802.field_8543, 64);
        STACKABLE_ITEMS.put(class_1802.field_8833, 16);
        STACKABLE_ITEMS.put(class_1802.field_17534, 16);
        STACKABLE_ITEMS.put(class_1802.field_8045, 16);
        STACKABLE_ITEMS.put(class_1802.field_8388, 16);
        STACKABLE_ITEMS.put(class_1802.field_8063, 16);
        STACKABLE_ITEMS.put(class_1802.field_8836, 16);
        STACKABLE_ITEMS.put(class_1802.field_8069, 16);
        STACKABLE_ITEMS.put(class_1802.field_8220, 16);
        STACKABLE_ITEMS.put(class_1802.field_8550, 64);
        STACKABLE_ITEMS.put(class_1802.field_8108, 64);
        STACKABLE_ITEMS.put(class_1802.field_28354, 64);
        STACKABLE_ITEMS.put(class_1802.field_8666, 64);
        STACKABLE_ITEMS.put(class_1802.field_8714, 64);
        STACKABLE_ITEMS.put(class_1802.field_37533, 64);
        STACKABLE_ITEMS.put(class_1802.field_8478, 64);
        STACKABLE_ITEMS.put(class_1802.field_8103, 64);
        STACKABLE_ITEMS.put(class_1802.field_8187, 64);
        STACKABLE_ITEMS.put(class_1802.field_8705, 64);
        STACKABLE_ITEMS.put(class_1802.field_27876, 64);
        STACKABLE_ITEMS.put(class_1802.field_8175, 16);
        STACKABLE_ITEMS.put(class_1802.field_18138, 16);
        STACKABLE_ITEMS.put(class_1802.field_8578, 16);
        STACKABLE_ITEMS.put(class_1802.field_8560, 16);
        STACKABLE_ITEMS.put(class_1802.field_8807, 16);
        STACKABLE_ITEMS.put(class_1802.field_8258, 64);
        STACKABLE_ITEMS.put(class_1802.field_8754, 64);
        STACKABLE_ITEMS.put(class_1802.field_8146, 64);
        STACKABLE_ITEMS.put(class_1802.field_8112, 64);
        STACKABLE_ITEMS.put(class_1802.field_8464, 64);
        STACKABLE_ITEMS.put(class_1802.field_8789, 64);
        STACKABLE_ITEMS.put(class_1802.field_8059, 64);
        STACKABLE_ITEMS.put(class_1802.field_8863, 64);
        STACKABLE_ITEMS.put(class_1802.field_8368, 64);
        STACKABLE_ITEMS.put(class_1802.field_8679, 64);
        STACKABLE_ITEMS.put(class_1802.field_8390, 64);
        STACKABLE_ITEMS.put(class_1802.field_8893, 64);
        STACKABLE_ITEMS.put(class_1802.field_8286, 64);
        STACKABLE_ITEMS.put(class_1802.field_8349, 64);
        STACKABLE_ITEMS.put(class_1802.field_8417, 64);
        STACKABLE_ITEMS.put(class_1802.field_8262, 64);
        STACKABLE_ITEMS.put(class_1802.field_8539, 64);
        STACKABLE_ITEMS.put(class_1802.field_8617, 64);
        STACKABLE_ITEMS.put(class_1802.field_8855, 64);
        STACKABLE_ITEMS.put(class_1802.field_8572, 64);
        STACKABLE_ITEMS.put(class_1802.field_8124, 64);
        STACKABLE_ITEMS.put(class_1802.field_8586, 64);
        STACKABLE_ITEMS.put(class_1802.field_8824, 64);
        STACKABLE_ITEMS.put(class_1802.field_8049, 64);
        STACKABLE_ITEMS.put(class_1802.field_8295, 64);
        STACKABLE_ITEMS.put(class_1802.field_8778, 64);
        STACKABLE_ITEMS.put(class_1802.field_8629, 64);
        STACKABLE_ITEMS.put(class_1802.field_8128, 64);
        STACKABLE_ITEMS.put(class_1802.field_8379, 64);
        STACKABLE_ITEMS.put(class_1802.field_8671, 64);
        STACKABLE_ITEMS.put(class_1802.field_8329, 64);
        STACKABLE_ITEMS.put(class_1802.field_8405, 64);
        STACKABLE_ITEMS.put(class_1802.field_8533, 16);
        STACKABLE_ITEMS.put(class_1802.field_8486, 16);
        STACKABLE_ITEMS.put(class_1802.field_8442, 16);
        STACKABLE_ITEMS.put(class_1802.field_8730, 16);
        STACKABLE_ITEMS.put(class_1802.field_8094, 16);
        STACKABLE_ITEMS.put(class_1802.field_8138, 16);
        STACKABLE_ITEMS.put(class_1802.field_37531, 16);
        STACKABLE_ITEMS.put(class_1802.field_42706, 16);
        STACKABLE_ITEMS.put(class_1802.field_54620, 16);
        STACKABLE_ITEMS.put(class_1802.field_40224, 16);
        STACKABLE_ITEMS.put(class_1802.field_38216, 16);
        STACKABLE_ITEMS.put(class_1802.field_38217, 16);
        STACKABLE_ITEMS.put(class_1802.field_38218, 16);
        STACKABLE_ITEMS.put(class_1802.field_38212, 16);
        STACKABLE_ITEMS.put(class_1802.field_38213, 16);
        STACKABLE_ITEMS.put(class_1802.field_38214, 16);
        STACKABLE_ITEMS.put(class_1802.field_38215, 16);
        STACKABLE_ITEMS.put(class_1802.field_42707, 16);
        STACKABLE_ITEMS.put(class_1802.field_54621, 16);
        STACKABLE_ITEMS.put(class_1802.field_40225, 16);
        STACKABLE_ITEMS.put(class_1802.field_8574, 64);
        STACKABLE_ITEMS.put(class_1802.field_8150, 64);
        STACKABLE_ITEMS.put(class_1802.field_8436, 64);
    }
}

