/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.common.ant;

import com.yworks.common.ResourcePolicy;
import com.yworks.common.ShrinkBag;
import com.yworks.common.ant.AttributesSection;
import com.yworks.common.ant.Exclude;
import com.yworks.common.ant.InOutPair;
import com.yworks.yguard.ant.Property;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

public abstract class YGuardBaseTask
extends Task {
    protected static final boolean MODE_STANDALONE = false;
    protected static final boolean MODE_NESTED = true;
    protected final boolean mode;
    protected List<ShrinkBag> pairs;
    protected Path resourceClassPath;
    protected List<AttributesSection> attributesSections;
    protected Map properties = new HashMap();

    public YGuardBaseTask() {
        this.mode = false;
    }

    public YGuardBaseTask(boolean mode) {
        this.mode = mode;
    }

    public AttributesSection createAttribute() {
        if (this.attributesSections == null) {
            this.attributesSections = new ArrayList<AttributesSection>();
        }
        AttributesSection as = this.newAttributesSection();
        this.attributesSections.add(as);
        return as;
    }

    protected AttributesSection newAttributesSection() {
        return new AttributesSection();
    }

    public ShrinkBag createInOutPair() {
        if (this.pairs == null) {
            this.pairs = new ArrayList<ShrinkBag>();
        }
        InOutPair pair = this.newInOutPair();
        this.pairs.add(pair);
        return pair;
    }

    protected InOutPair newInOutPair() {
        return new InOutPair();
    }

    public void addConfiguredInOutPairs(InOutPairSection section) {
        if (this.pairs == null) {
            this.pairs = new ArrayList<ShrinkBag>();
        }
        this.pairs.addAll(section.createShrinkBags(this.getProject()));
    }

    public void addConfiguredInOutPair(ShrinkBag pair) {
        if (this.pairs == null) {
            this.pairs = new ArrayList<ShrinkBag>();
        }
        this.pairs.add(pair);
    }

    public Path createExternalClasses() {
        if (this.resourceClassPath != null) {
            throw new IllegalArgumentException("Only one externalclasses element allowed!");
        }
        this.resourceClassPath = new Path(this.getProject());
        return this.resourceClassPath;
    }

    public void setResourceClassPath(Path path) {
        this.resourceClassPath = path;
    }

    public abstract Exclude createKeep();

    public abstract void addAttributesSections(List<AttributesSection> var1);

    public void addConfiguredProperty(Property p) {
        this.properties.put(p.getName(), p.getValue());
    }

    public static final class InOutPairSection {
        private FileSet set;
        private Mapper mapper;
        private ResourcePolicy resources = ResourcePolicy.COPY;

        public void setResources(String resourcesStr) {
            try {
                this.resources = ResourcePolicy.valueOf(resourcesStr.trim().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new BuildException("Invalid resource policy: " + resourcesStr);
            }
        }

        public void addConfiguredFileSet(FileSet set) {
            this.set = set;
        }

        public void add(Mapper mapper) {
            this.mapper = mapper;
        }

        public List<ShrinkBag> createShrinkBags(Project project) {
            if (this.mapper == null) {
                Mapper.MapperType type = new Mapper.MapperType();
                type.setValue("glob");
                this.mapper = new Mapper(project);
                this.mapper.setType(type);
                this.mapper.setFrom("*.jar");
                this.mapper.setTo("*_obf.jar");
            }
            ArrayList<ShrinkBag> result = new ArrayList<ShrinkBag>();
            DirectoryScanner directoryScanner = this.set.getDirectoryScanner(project);
            String[] files = directoryScanner.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                String inFile = files[i];
                String[] outFile = this.mapper.getImplementation().mapFileName(inFile);
                if (outFile == null || outFile.length < 1 || outFile[0].equals(inFile)) {
                    throw new BuildException("Cannot obfuscate " + inFile + " using that mapping");
                }
                InOutPair pair = new InOutPair();
                pair.resources = this.resources;
                pair.setIn(FileUtils.newFileUtils().resolveFile(directoryScanner.getBasedir(), inFile));
                pair.setOut(FileUtils.newFileUtils().resolveFile(directoryScanner.getBasedir(), outFile[0]));
                result.add(pair);
            }
            return result;
        }
    }
}

