/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard;

import com.yworks.util.Version;
import com.yworks.yguard.YGuardLogParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;

class LogParserView {
    LogParserView() {
    }

    void show(File initialPath) {
        final JTree tree = new JTree(new DefaultTreeModel(new DefaultMutableTreeNode()));
        tree.setCellRenderer(new TreeCellRenderer(){
            DefaultTreeCellRenderer dtcr = new DefaultTreeCellRenderer();

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JComponent c = (JComponent)this.dtcr.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                DefaultMutableTreeNode dmtr = (DefaultMutableTreeNode)value;
                if (dmtr.getUserObject() != null) {
                    this.dtcr.setIcon(((YGuardLogParser.Mapped)dmtr.getUserObject()).getIcon());
                }
                return c;
            }
        });
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        JPanel textPanel = new JPanel(new BorderLayout());
        final JTextArea textArea = new JTextArea();
        textArea.setMinimumSize(new Dimension(600, 200));
        JScrollPane textScrollPane = new JScrollPane(textArea);
        textScrollPane.getViewport().setPreferredSize(new Dimension(400, 200));
        textPanel.add((Component)textScrollPane, "Center");
        JButton button = new JButton("Deobfuscate!");
        button.setMnemonic('D');
        textPanel.add((Component)button, "South");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogParserView.deobfuscate(LogParserView.getParser(tree), textArea);
            }
        });
        final JPanel top = new JPanel(new BorderLayout());
        top.add((Component)new JScrollPane(tree), "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(3, 0, 0));
        buttonPanel.add(new JButton(new AbstractAction("Sort by Mapping"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
                LogParserView.sort(model, (Comparator)new MappedNameComparator());
            }
        }));
        buttonPanel.add(new JButton(new AbstractAction("Sort by Names"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
                LogParserView.sort(model, (Comparator)new NameComparator());
            }
        }));
        top.add((Component)buttonPanel, "North");
        final JFrame frame = new JFrame(LogParserView.newTitle(initialPath.getAbsolutePath()));
        JMenu recent = new JMenu("Open Recent");
        JFileChooser jfc = new JFileChooser();
        jfc.addChoosableFileFilter(new FileFilterImpl(".gz", "Compressed XML (*.gz)"));
        jfc.addChoosableFileFilter(new FileFilterImpl(".xml", "XML (*.xml)"));
        jfc.setAcceptAllFileFilterUsed(true);
        jfc.setFileFilter(jfc.getAcceptAllFileFilter());
        File parent = initialPath.getParentFile();
        if (parent != null) {
            jfc.setCurrentDirectory(parent);
        }
        UiContext ctx = new UiContext(frame, tree, textArea, recent, jfc);
        try {
            LogParserView.setParser(tree, LogParserView.newParser(initialPath));
            LogParserView.addRecent(ctx, initialPath);
        }
        catch (Exception ex) {
            LogParserView.setParser(tree, new YGuardLogParser());
            frame.setTitle("Element Mapping - yGuard " + Version.getVersion());
            final String msg = LogParserView.toErrorMessage(initialPath, ex);
            frame.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    frame.removeComponentListener(this);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LogParserView.showErrorMessage(msg, tree);
                        }
                    });
                }
            });
        }
        JMenu file = new JMenu("File");
        file.add(new AbstractOpenAction(ctx, "Open"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser jfc = this.context.fileChooser;
                if (jfc.showOpenDialog(top) == 0) {
                    this.open(jfc.getSelectedFile());
                }
            }

            @Override
            void onOpened(UiContext context, File path) {
                LogParserView.addRecent(context, path);
                super.onOpened(context, path);
            }
        });
        file.add(recent);
        file.addSeparator();
        file.add(new AbstractAction("Quit"){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        JMenu help = new JMenu("?");
        help.add(new AbstractAction("About"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JLabel jl = new JLabel("Element Mapping - yGuard " + Version.getVersion());
                JOptionPane.showMessageDialog(top, jl, "About", -1);
            }
        });
        JMenuBar jmb = new JMenuBar();
        jmb.add(file);
        jmb.add(help);
        frame.setDefaultCloseOperation(3);
        frame.setJMenuBar(jmb);
        frame.setContentPane(new JSplitPane(0, top, textPanel));
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    static void addRecent(UiContext context, File path) {
        JMenu menu = context.recentMenu;
        int n = menu.getItemCount();
        if (n > 9) {
            menu.remove(n - 1);
        }
        RecentAction ra = new RecentAction(context, path);
        JMenuItem jc = menu.add(ra);
        ra.setItem(jc);
        if (n > 0) {
            menu.remove(menu.getItemCount() - 1);
            menu.add((Component)jc, 0);
        }
    }

    static void showErrorMessage(String text, JComponent parent) {
        JTextArea jta = new JTextArea(text);
        jta.setEditable(false);
        JScrollPane jsp = new JScrollPane(jta);
        jsp.setPreferredSize(new Dimension(400, 600));
        JOptionPane.showMessageDialog(parent, jsp, "Error", 0);
    }

    static String toErrorMessage(File file, Exception ex) {
        StringWriter sw = new StringWriter();
        sw.write("Could not read ");
        sw.write(file.getAbsolutePath());
        sw.write(":\n");
        ex.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    static YGuardLogParser getParser(JTree tree) {
        return (YGuardLogParser)tree.getClientProperty("PARSER");
    }

    static void setParser(JTree tree, YGuardLogParser parser) {
        tree.setModel(parser.getTreeModel());
        tree.putClientProperty("PARSER", parser);
    }

    static YGuardLogParser newParser(File file) throws Exception {
        YGuardLogParser parser = new YGuardLogParser();
        parser.parse(file);
        return parser;
    }

    static String newTitle(String path) {
        String t;
        String string = t = path == null ? "" : path.trim();
        if (t.length() > 31) {
            return LogParserView.newTitleSuffix(t);
        }
        return t;
    }

    static String newTitleSuffix(String path) {
        int idx = path.lastIndexOf(File.separatorChar);
        if (idx > -1) {
            idx = path.lastIndexOf(File.separatorChar, idx - 1);
        }
        if (idx > -1) {
            return "..." + path.substring(idx);
        }
        return path;
    }

    static void deobfuscate(YGuardLogParser parser, JTextArea textArea) {
        String[] lines = textArea.getText().split("\n");
        lines = parser.translate(lines);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < lines.length; ++i) {
            sb.append(lines[i]).append("\n");
        }
        textArea.setText(sb.toString());
        textArea.setCaretPosition(0);
    }

    static void sort(DefaultTreeModel model, Comparator c) {
        LogParserView.sortRecursively((DefaultMutableTreeNode)model.getRoot(), c);
        model.nodeStructureChanged((DefaultMutableTreeNode)model.getRoot());
    }

    private static void sortRecursively(DefaultMutableTreeNode parent, Comparator c) {
        if (parent.getChildCount() > 0) {
            if (parent.getChildCount() > 1) {
                LogParserView.sort(parent, c);
            }
            Enumeration<TreeNode> enu = parent.children();
            while (enu.hasMoreElements()) {
                DefaultMutableTreeNode tn = (DefaultMutableTreeNode)enu.nextElement();
                LogParserView.sortRecursively(tn, c);
            }
        }
    }

    private static void sort(DefaultMutableTreeNode parent, Comparator c) {
        int i;
        DefaultMutableTreeNode[] children = new DefaultMutableTreeNode[parent.getChildCount()];
        for (i = 0; i < children.length; ++i) {
            children[i] = (DefaultMutableTreeNode)parent.getChildAt(i);
        }
        parent.removeAllChildren();
        Arrays.sort(children, c);
        for (i = 0; i < children.length; ++i) {
            parent.add(children[i]);
        }
    }

    private static final class RecentAction
    extends AbstractOpenAction {
        final File path;
        JMenuItem item;

        RecentAction(UiContext context, File path) {
            super(context, LogParserView.newTitleSuffix(path.getAbsolutePath()));
            this.path = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.open(this.path);
        }

        @Override
        void onOpened(UiContext context, File path) {
            this.updateRecent(context, path);
            this.updateFileChooser(context, path);
            super.onOpened(context, path);
        }

        private void updateRecent(UiContext context, File path) {
            JMenu menu = context.recentMenu;
            JMenuItem ami = this.getItem();
            if (ami != null) {
                int n = menu.getItemCount();
                for (int i = 0; i < n; ++i) {
                    JMenuItem mi = menu.getItem(i);
                    if (mi != ami) continue;
                    menu.remove(i);
                    menu.add((Component)ami, 0);
                    break;
                }
            }
        }

        private void updateFileChooser(UiContext context, File path) {
            File parent = path.getParentFile();
            if (parent != null) {
                context.fileChooser.setCurrentDirectory(parent);
            }
        }

        JMenuItem getItem() {
            return this.item;
        }

        void setItem(JMenuItem jc) {
            this.item = jc;
        }
    }

    private static abstract class AbstractOpenAction
    extends AbstractAction {
        final UiContext context;

        AbstractOpenAction(UiContext context, String name) {
            super(name);
            this.context = context;
        }

        void open(File path) {
            JTree tree = this.context.mappingTree;
            try {
                LogParserView.setParser(tree, LogParserView.newParser(path));
                this.onOpened(this.context, path);
            }
            catch (Exception ex) {
                LogParserView.showErrorMessage(LogParserView.toErrorMessage(path, ex), tree);
            }
        }

        void onOpened(UiContext context, File path) {
            context.textArea.setText("");
            context.frame.setTitle(LogParserView.newTitle(path.getAbsolutePath()));
        }
    }

    private static final class UiContext {
        final JFrame frame;
        final JTree mappingTree;
        final JTextArea textArea;
        final JMenu recentMenu;
        final JFileChooser fileChooser;

        UiContext(JFrame frame, JTree mappingTree, JTextArea textArea, JMenu recentMenu, JFileChooser fileChooser) {
            this.frame = frame;
            this.mappingTree = mappingTree;
            this.textArea = textArea;
            this.recentMenu = recentMenu;
            this.fileChooser = fileChooser;
        }
    }

    private static class FileFilterImpl
    extends FileFilter {
        private final String suffix;
        private final String description;

        FileFilterImpl(String suffix, String description) {
            this.suffix = suffix == null ? "" : suffix.toLowerCase();
            this.description = description;
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(this.suffix);
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    static final class NameComparator
    implements Comparator {
        NameComparator() {
        }

        public int compare(Object o1, Object o2) {
            YGuardLogParser.Mapped m1 = (YGuardLogParser.Mapped)((DefaultMutableTreeNode)o1).getUserObject();
            YGuardLogParser.Mapped m2 = (YGuardLogParser.Mapped)((DefaultMutableTreeNode)o2).getUserObject();
            if (m1.getClass() != m2.getClass()) {
                if (m1.getClass() == YGuardLogParser.PackageStruct.class) {
                    return -1;
                }
                if (m2.getClass() == YGuardLogParser.PackageStruct.class) {
                    return 1;
                }
                if (m1.getClass() == YGuardLogParser.ClassStruct.class) {
                    return -1;
                }
                if (m2.getClass() == YGuardLogParser.ClassStruct.class) {
                    return 1;
                }
                if (m1.getClass() == YGuardLogParser.MethodStruct.class) {
                    return -1;
                }
                if (m2.getClass() == YGuardLogParser.MethodStruct.class) {
                    return 1;
                }
            }
            return m1.getName().compareTo(m2.getName());
        }
    }

    static final class MappedNameComparator
    implements Comparator {
        MappedNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            YGuardLogParser.Mapped m1 = (YGuardLogParser.Mapped)((DefaultMutableTreeNode)o1).getUserObject();
            YGuardLogParser.Mapped m2 = (YGuardLogParser.Mapped)((DefaultMutableTreeNode)o2).getUserObject();
            if (m1.getClass() != m2.getClass()) {
                if (m1.getClass() == YGuardLogParser.PackageStruct.class) {
                    return -1;
                }
                if (m2.getClass() == YGuardLogParser.PackageStruct.class) {
                    return 1;
                }
                if (m1.getClass() == YGuardLogParser.ClassStruct.class) {
                    return -1;
                }
                if (m2.getClass() == YGuardLogParser.ClassStruct.class) {
                    return 1;
                }
                if (m1.getClass() == YGuardLogParser.MethodStruct.class) {
                    return -1;
                }
                if (m2.getClass() == YGuardLogParser.MethodStruct.class) {
                    return 1;
                }
            }
            return m1.getMappedName().compareTo(m2.getMappedName());
        }
    }
}

