/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringReplacer {
    Pattern pattern;

    public StringReplacer(String patternString) {
        this.setPattern(patternString);
    }

    public void setPattern(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    public void replace(String in, StringBuffer out, Function<String, String> map) {
        this.replaceImpl(in, out, map);
    }

    public void replace(Reader in, Writer out, Function<String, String> map) throws IOException {
        StringBuffer result = new StringBuffer(80);
        BufferedReader bin = new BufferedReader(in);
        String line = bin.readLine();
        while (line != null) {
            this.replaceImpl(line, result, map);
            out.write(result.toString());
            out.write(10);
            line = bin.readLine();
        }
    }

    private void replaceImpl(String in, StringBuffer out, Function<String, String> map) {
        out.setLength(0);
        Matcher matcher = this.pattern.matcher(in);
        while (matcher.find()) {
            String match = in.substring(matcher.start(), matcher.end());
            String replacement = StringReplacer.safeGet(map, match);
            if (replacement.indexOf(92) >= 0) {
                replacement = replacement.replaceAll("\\\\", "\\\\\\\\");
            }
            if (replacement.indexOf(36) >= 0) {
                replacement = replacement.replaceAll("\\$", "\\\\\\$");
            }
            matcher.appendReplacement(out, replacement);
        }
        matcher.appendTail(out);
    }

    private static String safeGet(Function<String, String> map, String key) {
        String value = map.apply(key);
        return value == null ? key : value;
    }
}

