/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.obf.classfile.ConstantPool;
import com.yworks.yguard.obf.classfile.ElementValueInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ElementValuePairInfo {
    protected int u2ElementNameIndex;
    protected ElementValueInfo elementValue;

    private ElementValuePairInfo() {
    }

    public static ElementValuePairInfo create(DataInput din) throws IOException {
        ElementValuePairInfo evp = new ElementValuePairInfo();
        evp.read(din);
        return evp;
    }

    protected void read(DataInput din) throws IOException {
        this.u2ElementNameIndex = din.readUnsignedShort();
        this.elementValue = ElementValueInfo.create(din);
    }

    protected void markUtf8RefsInInfo(ConstantPool pool) {
        pool.getCpEntry(this.u2ElementNameIndex).incRefCount();
        this.elementValue.markUtf8RefsInInfo(pool);
    }

    public void write(DataOutput dout) throws IOException {
        dout.writeShort(this.u2ElementNameIndex);
        this.elementValue.write(dout);
    }

    public int getU2ElementNameIndex() {
        return this.u2ElementNameIndex;
    }

    public ElementValueInfo getElementValue() {
        return this.elementValue;
    }
}

