/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.obf.classfile.AttrInfo;
import com.yworks.yguard.obf.classfile.ClassFile;
import com.yworks.yguard.obf.classfile.ConstantPool;
import com.yworks.yguard.obf.classfile.StackMapFrameInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class StackMapTableAttrInfo
extends AttrInfo {
    private int u2NumberOfEntries;
    private StackMapFrameInfo[] entries;

    protected StackMapTableAttrInfo(ClassFile cf, int attrNameIndex, int attrLength) {
        super(cf, attrNameIndex, attrLength);
    }

    @Override
    protected String getAttrName() {
        return "StackMapTable";
    }

    protected StackMapFrameInfo[] getEntries() {
        return this.entries;
    }

    @Override
    protected void markUtf8RefsInInfo(ConstantPool pool) {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i].markUtf8Refs(pool);
        }
    }

    @Override
    protected void readInfo(DataInput din) throws IOException {
        this.u2NumberOfEntries = din.readUnsignedShort();
        this.entries = new StackMapFrameInfo[this.u2NumberOfEntries];
        for (int i = 0; i < this.u2NumberOfEntries; ++i) {
            this.entries[i] = StackMapFrameInfo.create(din);
        }
    }

    @Override
    public void writeInfo(DataOutput dout) throws IOException {
        dout.writeShort(this.u2NumberOfEntries);
        for (int i = 0; i < this.u2NumberOfEntries; ++i) {
            this.entries[i].write(dout);
        }
    }
}

