/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yshrink.core;

import com.yworks.common.ShrinkBag;
import com.yworks.logging.Logger;
import com.yworks.util.abstractjar.Factory;
import com.yworks.util.abstractjar.StreamProvider;
import com.yworks.yshrink.model.AbstractDescriptor;
import com.yworks.yshrink.model.AnnotationUsage;
import com.yworks.yshrink.model.ClassDescriptor;
import com.yworks.yshrink.model.EdgeType;
import com.yworks.yshrink.model.FieldDescriptor;
import com.yworks.yshrink.model.Invocation;
import com.yworks.yshrink.model.MethodDescriptor;
import com.yworks.yshrink.model.Model;
import com.yworks.yshrink.model.ModelVisitor;
import com.yworks.yshrink.util.Util;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

public class Analyzer {
    private static final String SYNTHETIC_DOT_CLASS_FIELD_START = "class$";
    private static final String CLASS_DESC = "Ljava/lang/Class;";

    public void createEdges(Model model) {
        this.createInheritanceEdges(model);
        this.createDependencyEdges(model);
    }

    public void initModel(Model model, List<ShrinkBag> bags) throws IOException {
        for (ShrinkBag bag : bags) {
            ModelVisitor mv = new ModelVisitor(model, bag.getIn());
            Logger.log("parsing " + bag.getIn());
            this.visitAllClasses(mv, bag.getIn());
        }
        for (ClassDescriptor cd : model.getAllClassDescriptors()) {
            MethodDescriptor clinit = cd.getMethod("<clinit>", Model.VOID_DESC);
            if (!cd.isInnerClass() && clinit == null) {
                clinit = model.newMethodDescriptor(cd, 8, "<clinit>", Model.VOID_DESC, null, cd.getSourceJar());
            }
            if (null != clinit) {
                model.createDependencyEdge(cd, clinit, EdgeType.INVOKES);
            }
            this.createEnumEdges(model, cd);
        }
    }

    private void visitAllClasses(ClassVisitor v, File jarFile) throws IOException {
        StreamProvider provider = Factory.newStreamProvider(jarFile);
        DataInputStream stream = provider.getNextClassEntryStream();
        while (stream != null) {
            ClassReader cr = new ClassReader(stream);
            cr.accept(v, 0);
            Analyzer.close(stream);
            stream = provider.getNextClassEntryStream();
        }
        try {
            provider.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void close(InputStream is) {
        try {
            is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createInheritanceEdges(Model model) {
        for (ClassDescriptor cm : model.getAllClassDescriptors()) {
            if (model.isClassModeled(cm.getSuperName())) {
                ClassDescriptor superDescriptor = model.getClassDescriptor(cm.getSuperName());
                model.createDependencyEdge(cm, superDescriptor, EdgeType.EXTENDS);
            }
            for (String interfc : cm.getInterfaces()) {
                if (!model.isClassModeled(interfc)) continue;
                ClassDescriptor superDescriptor = model.getClassDescriptor(interfc);
                model.createDependencyEdge(cm, superDescriptor, EdgeType.IMPLEMENTS);
            }
        }
        model.setSimpleModelSet();
    }

    public void createDependencyEdges(Model model) {
        for (ClassDescriptor cd : model.getAllClassDescriptors()) {
            this.createAnnotationEdges(cd, model);
            model.createDependencyEdge(cd.getNewNode(), cd.getNode(), EdgeType.MEMBER_OF);
            this.createInnerClassEdges(model, cd);
            this.createAssumeEdges(model, cd);
            for (MethodDescriptor md : cd.getMethods()) {
                this.createAnnotationEdges(md, model);
                model.createDependencyEdge(md, cd, EdgeType.MEMBER_OF);
                this.createReferenceEdges(model, md);
                this.createMethodSignatureEdges(model, md);
                this.createInvokeEdges(model, cd, md);
                this.createTypeInstructionEdges(model, md);
            }
            for (FieldDescriptor fd : cd.getFields()) {
                this.createAnnotationEdges(fd, model);
                model.createDependencyEdge(fd, cd, EdgeType.MEMBER_OF);
                String fieldTypeName = Util.getTypeNameFromDescriptor(fd.getDesc());
                if (!model.isClassModeled(fieldTypeName)) continue;
                ClassDescriptor fieldType = model.getClassDescriptor(fieldTypeName);
                model.createDependencyEdge(fd, fieldType, EdgeType.RESOLVE);
            }
        }
    }

    private void createAnnotationEdges(AbstractDescriptor cd, Model model) {
        for (AnnotationUsage annotationUsage : cd.getAnnotations()) {
            if (!model.isClassModeled(annotationUsage.getDescriptor())) continue;
            ClassDescriptor annotationClassDescriptor = model.getClassDescriptor(annotationUsage.getDescriptor());
            model.createDependencyEdge(cd, annotationClassDescriptor, EdgeType.REFERENCES);
            block1: for (String field : annotationUsage.getFieldUsages()) {
                for (MethodDescriptor methodDescriptor : annotationClassDescriptor.getMethods()) {
                    if (!methodDescriptor.getName().equals(field)) continue;
                    model.createDependencyEdge(cd, methodDescriptor, EdgeType.RESOLVE);
                    continue block1;
                }
            }
        }
    }

    private void createTypeInstructionEdges(Model model, MethodDescriptor md) {
        for (AbstractMap.SimpleEntry<Object, Object> typeInstruction : md.getTypeInstructions()) {
            int opcode = (Integer)typeInstruction.getKey();
            String desc = (String)typeInstruction.getValue();
            String type = Util.getTypeNameFromDescriptor(desc);
            if (opcode == 189 || opcode == 197 || opcode == 193 || opcode == 192 || opcode == 18) {
                if (!model.isClassModeled(type)) continue;
                ClassDescriptor cd = model.getClassDescriptor(type);
                model.createDependencyEdge(md, cd, EdgeType.RESOLVE);
                continue;
            }
            if (opcode != 187 || !model.isClassModeled(type)) continue;
            ClassDescriptor targetClass = model.getClassDescriptor(type);
            model.createDependencyEdge(md.getNode(), targetClass.getNewNode(), EdgeType.CREATES);
        }
    }

    private void createEnumEdges(Model model, ClassDescriptor cd) {
        HashSet<String> parents = new HashSet<String>();
        model.getAllAncestorClasses(cd.getName(), parents);
        if (parents.contains("java/lang/Enum")) {
            String enumName = cd.getName();
            Type enumType = Type.getType(Util.verboseToNativeType(enumName));
            Type stringType = Type.getType(Util.verboseToNativeType("java/lang/String"));
            Type enumArray = Type.getType(Util.verboseToNativeType(enumName + "[]"));
            Collection<MethodDescriptor> methods = cd.getMethods();
            for (MethodDescriptor method : methods) {
                boolean isStatic = method.isStatic();
                Type retval = method.getReturnType();
                String name = method.getName();
                Type[] args = method.getArgumentTypes();
                if (isStatic && retval.equals(enumType) && "valueOf".equals(name) && args.length == 1 && args[0].equals(stringType)) {
                    model.createDependencyEdge(cd, method, EdgeType.INVOKES);
                    continue;
                }
                if (!isStatic || args.length != 0 || !"values".equals(name) || !retval.equals(enumArray)) continue;
                model.createDependencyEdge(cd, method, EdgeType.INVOKES);
            }
        }
    }

    private void createAssumeEdges(Model model, ClassDescriptor cd) {
        if (cd.isInterface()) {
            return;
        }
        Object newNode = cd.getNewNode();
        if (newNode == null) {
            Logger.err("no NEW-Node found for " + cd.getName());
            return;
        }
        ArrayList<Method> externalMethods = new ArrayList<Method>(5);
        boolean resolvable = model.getAllExternalAncestorMethods(cd.getName(), externalMethods);
        if (resolvable) {
            for (Method method : externalMethods) {
                String mDesc;
                String mName = method.getName();
                if (cd.implementsMethod(mName, mDesc = Type.getMethodDescriptor(method))) {
                    model.createDependencyEdge(newNode, cd.getMethod(mName, mDesc).getNode(), EdgeType.ASSUME);
                    continue;
                }
                ArrayList<ClassDescriptor> modeledClasses = new ArrayList<ClassDescriptor>();
                for (String interfaceName : cd.getInterfaces()) {
                    if (!model.isClassModeled(interfaceName)) continue;
                    modeledClasses.add(model.getClassDescriptor(interfaceName));
                }
                if (model.isClassModeled(cd.getSuperName())) {
                    modeledClasses.add(model.getClassDescriptor(cd.getSuperName()));
                }
                for (ClassDescriptor superDescriptor : modeledClasses) {
                    this.createEdgeToImplementingMethod(superDescriptor, mName, mDesc, model, newNode, EdgeType.ASSUME, false);
                }
            }
        } else {
            for (MethodDescriptor md : cd.getMethods()) {
                if (md.isPrivate()) continue;
                model.createDependencyEdge(newNode, md.getNode(), EdgeType.ASSUME);
            }
        }
        ArrayList<MethodDescriptor> internalMethods = new ArrayList<MethodDescriptor>();
        model.getAllInternalAncestorEntrypointMethods(cd.getName(), internalMethods);
        for (MethodDescriptor md : internalMethods) {
            String mName = md.getName();
            String mDesc = md.getDesc();
            if (md.isStatic() && !mName.equals("<init>")) continue;
            if (cd.implementsMethod(mName, mDesc)) {
                model.createDependencyEdge(newNode, cd.getMethod(mName, mDesc).getNode(), EdgeType.ASSUME);
                continue;
            }
            if (!model.isClassModeled(cd.getSuperName())) continue;
            ClassDescriptor superCd = model.getClassDescriptor(cd.getSuperName());
            this.createEdgeToImplementingMethod(superCd, mName, mDesc, model, newNode, EdgeType.ASSUME, false);
        }
    }

    private void createInvokeEdges(Model model, ClassDescriptor cd, MethodDescriptor md) {
        for (Invocation invocation : md.getInvocations()) {
            MethodDescriptor initMethod;
            int opcode = invocation.getOpcode();
            String targetType = invocation.getType();
            String targetMethod = invocation.getName();
            String targetDesc = invocation.getDesc();
            if (!model.isClassModeled(targetType)) continue;
            ClassDescriptor target = model.getClassDescriptor(targetType);
            if (opcode == 183 && targetType.equals(cd.getSuperName())) {
                if ("<init>".equals(targetMethod) && "<init>".equals(md.getName())) {
                    initMethod = target.getMethod(targetMethod, targetDesc);
                    model.createDependencyEdge(md, initMethod, EdgeType.CHAIN);
                } else {
                    while (!target.implementsMethod(targetMethod, targetDesc) && model.isClassModeled(target.getSuperName())) {
                        target = model.getClassDescriptor(target.getSuperName());
                    }
                    if (target.implementsMethod(targetMethod, targetDesc)) {
                        model.createDependencyEdge(md, target.getMethod(targetMethod, targetDesc), EdgeType.SUPER);
                    }
                }
            } else {
                if (target.isInterface() || target.isAbstract()) {
                    this.createEdgeToDeclaration(model, target, targetMethod, targetDesc, md);
                }
                this.createEdgesToAncestorMethods(model, target, md, targetMethod, targetDesc);
                if (!targetMethod.equals("<init>")) {
                    this.createSubtreeEdges(model, cd, target, md, targetMethod, targetDesc);
                }
            }
            if (opcode != 186) continue;
            initMethod = target.getMethod(targetMethod, targetDesc);
            model.createDependencyEdge(md, initMethod, EdgeType.INVOKEDYNAMIC);
        }
    }

    private void createEdgeToDeclaration(Model model, ClassDescriptor targetClass, String targetMethod, String targetDesc, MethodDescriptor source) {
        String superName;
        if (targetClass.implementsMethod(targetMethod, targetDesc) && (targetClass.isAbstract() || targetClass.isInterface())) {
            model.createDependencyEdge(source, targetClass.getMethod(targetMethod, targetDesc), EdgeType.RESOLVE);
            return;
        }
        String[] interfaces = targetClass.getInterfaces();
        if (null != interfaces) {
            for (String interfc : interfaces) {
                if (!model.isClassModeled(interfc)) continue;
                ClassDescriptor interfaceDesc = model.getClassDescriptor(interfc);
                this.createEdgeToDeclaration(model, interfaceDesc, targetMethod, targetDesc, source);
            }
        }
        if (!targetClass.isInterface() && model.isClassModeled(superName = targetClass.getSuperName())) {
            ClassDescriptor superDesc = model.getClassDescriptor(superName);
            this.createEdgeToDeclaration(model, superDesc, targetMethod, targetDesc, source);
        }
    }

    private void createEdgesToAncestorMethods(Model model, ClassDescriptor owner, MethodDescriptor md, String targetMethod, String targetDesc) {
        Set<ClassDescriptor> implementingClasses;
        if (owner.isInterface() && (implementingClasses = model.getAllImplementingClasses(owner)) != null) {
            for (ClassDescriptor ownerImpl : implementingClasses) {
                this.createEdgesToAncestorMethods(model, ownerImpl, md, targetMethod, targetDesc);
                this.createSubtreeEdges(model, owner, ownerImpl, md, targetMethod, targetDesc);
            }
        }
        this.createEdgeToImplementingMethod(owner, targetMethod, targetDesc, model, md, EdgeType.INVOKES, true);
    }

    private void createEdgeToImplementingMethod(ClassDescriptor owner, String targetMethod, String targetDesc, Model model, MethodDescriptor md, EdgeType type, boolean createResolveEdge) {
        this.createEdgeToImplementingMethod(owner, targetMethod, targetDesc, model, md.getNode(), type, createResolveEdge);
    }

    private void findSuperInterfaces(Model model, ClassDescriptor start, List<ClassDescriptor> path, List<List<ClassDescriptor>> paths) {
        path.add(start);
        boolean hasModeled = false;
        int oldSize = path.size();
        for (String interfaceName : start.getInterfaces()) {
            if (!model.isClassModeled(interfaceName)) continue;
            hasModeled = true;
            if (path.size() > oldSize) {
                path = new ArrayList<ClassDescriptor>(path.subList(0, oldSize));
            }
            this.findSuperInterfaces(model, model.getClassDescriptor(interfaceName), path, paths);
        }
        if (!hasModeled) {
            paths.add(path);
        }
    }

    private void createEdgeToImplementingMethod(ClassDescriptor owner, String targetMethod, String targetDesc, Model model, Object node, EdgeType type, boolean createResolveEdge) {
        ArrayList<ClassDescriptor> classHierarchy = new ArrayList<ClassDescriptor>();
        classHierarchy.add(owner);
        while (!owner.implementsMethod(targetMethod, targetDesc) && model.isClassModeled(owner.getSuperName())) {
            model.createDependencyEdge(node, owner.getNode(), EdgeType.RESOLVE);
            owner = model.getClassDescriptor(owner.getSuperName());
            classHierarchy.add(owner);
        }
        if (owner.implementsMethod(targetMethod, targetDesc)) {
            MethodDescriptor targetMethodImp = owner.getMethod(targetMethod, targetDesc);
            model.createDependencyEdge(node, targetMethodImp.getNode(), type);
            if (createResolveEdge && !owner.isInterface()) {
                model.createDependencyEdge(node, targetMethodImp.getNode(), EdgeType.RESOLVE);
            }
            if (targetMethodImp.isStatic()) {
                model.createDependencyEdge(node, owner.getNode(), EdgeType.RESOLVE);
            }
        } else {
            HashSet<String> seen = new HashSet<String>();
            ArrayList<ClassDescriptor> interfaceDescriptors = new ArrayList<ClassDescriptor>();
            if (owner.isInterface()) {
                seen.add(owner.getName());
                interfaceDescriptors.add(owner);
            }
            for (ClassDescriptor classDescriptor : classHierarchy) {
                for (String interfaceName : classDescriptor.getInterfaces()) {
                    if (!seen.add(interfaceName) || !model.isClassModeled(interfaceName)) continue;
                    interfaceDescriptors.add(model.getClassDescriptor(interfaceName));
                }
            }
            ArrayList<List<ClassDescriptor>> interfaceHierarchies = new ArrayList<List<ClassDescriptor>>();
            for (ClassDescriptor cd : interfaceDescriptors) {
                this.findSuperInterfaces(model, cd, new ArrayList<ClassDescriptor>(), interfaceHierarchies);
            }
            boolean bl = false;
            ClassDescriptor mostSpecific = null;
            for (List list : interfaceHierarchies) {
                int dist;
                int n;
                int idx = Analyzer.indexOf(list, targetMethod, targetDesc);
                if (idx <= -1 || n >= (dist = Analyzer.lastIndexOf(list, targetMethod, targetDesc) - idx + 1)) continue;
                n = dist;
                mostSpecific = (ClassDescriptor)list.get(idx);
            }
            if (mostSpecific != null) {
                MethodDescriptor targetMethodImp = mostSpecific.getMethod(targetMethod, targetDesc);
                model.createDependencyEdge(node, targetMethodImp.getNode(), type);
                if (createResolveEdge) {
                    model.createDependencyEdge(node, targetMethodImp.getNode(), EdgeType.RESOLVE);
                }
                if (targetMethodImp.hasFlag(1) && !targetMethodImp.hasFlag(1024)) {
                    model.createDependencyEdge(node, owner.getNode(), EdgeType.RESOLVE);
                }
            }
        }
    }

    private static int indexOf(List<ClassDescriptor> interfaces, String methodName, String methodDescriptor) {
        int idx = -1;
        for (ClassDescriptor cd : interfaces) {
            ++idx;
            if (!cd.implementsMethod(methodName, methodDescriptor)) continue;
            return idx;
        }
        return -1;
    }

    private static int lastIndexOf(List<ClassDescriptor> interfaces, String methodName, String methodDescriptor) {
        int idx = interfaces.size();
        ListIterator<ClassDescriptor> it = interfaces.listIterator(idx);
        while (it.hasPrevious()) {
            --idx;
            ClassDescriptor cd = it.previous();
            if (!cd.implementsMethod(methodName, methodDescriptor)) continue;
            return idx;
        }
        return -1;
    }

    private void createSubtreeEdges(Model model, ClassDescriptor cd, ClassDescriptor target, MethodDescriptor mm, String targetMethod, String targetDesc) {
        ArrayList<ClassDescriptor> subClasses = new ArrayList<ClassDescriptor>();
        model.getInternalDescendants(target, subClasses);
        for (ClassDescriptor targetSubclass : subClasses) {
            if (targetSubclass == cd || !targetSubclass.implementsMethod(targetMethod, targetDesc)) continue;
            model.createDependencyEdge(mm, targetSubclass.getMethod(targetMethod, targetDesc), EdgeType.INVOKES);
        }
    }

    private void createMethodSignatureEdges(Model model, MethodDescriptor source) {
        for (Type argumentType : source.getArgumentTypes()) {
            String className = Util.getTypeNameFromDescriptor(argumentType.getDescriptor());
            if (!model.isClassModeled(className)) continue;
            model.createDependencyEdge(source, model.getClassDescriptor(className), EdgeType.RESOLVE);
        }
        Type returnType = source.getReturnType();
        String className = Util.getTypeNameFromDescriptor(returnType.getDescriptor());
        if (model.isClassModeled(className)) {
            model.createDependencyEdge(source, model.getClassDescriptor(className), EdgeType.RESOLVE);
        }
        if (source.getExceptions() != null) {
            for (String exception : source.getExceptions()) {
                if (!model.isClassModeled(exception)) continue;
                ClassDescriptor target = model.getClassDescriptor(exception);
                model.createDependencyEdge(source, target, EdgeType.RESOLVE);
            }
        }
    }

    private void createInnerClassEdges(Model model, ClassDescriptor cd) {
        ClassDescriptor enclosingClass;
        if (cd.isInnerClass()) {
            enclosingClass = model.getClassDescriptor(cd.getEnclosingClass());
            model.createDependencyEdge(cd, enclosingClass, EdgeType.ENCLOSE);
        }
        if (cd.getEnclosingMethod() != null) {
            enclosingClass = model.getClassDescriptor(cd.getEnclosingClass());
            MethodDescriptor enclosingMethodDescriptor = enclosingClass.getMethod(cd.getEnclosingMethod());
            if (null == enclosingMethodDescriptor) {
                Logger.log("Missing enclosing method declaration in " + enclosingClass.getName() + ": " + cd.getEnclosingMethod().getValue());
            } else {
                model.createDependencyEdge(cd, enclosingMethodDescriptor, EdgeType.ENCLOSE);
            }
        }
    }

    private void createReferenceEdges(Model model, MethodDescriptor md) {
        for (String[] fieldRef : md.getFieldRefs()) {
            String refDesc = fieldRef[0];
            String refName = fieldRef[1];
            if (!model.isClassModeled(refDesc)) continue;
            ClassDescriptor owner = model.getClassDescriptor(refDesc);
            boolean declarationFound = owner.declaresField(refName);
            while (model.isClassModeled(owner.getSuperName()) && !declarationFound) {
                if (!owner.declaresField(refName)) {
                    model.createDependencyEdge(md, owner, EdgeType.RESOLVE);
                    for (String interfc : owner.getInterfaces()) {
                        ClassDescriptor interfcDesc;
                        if (!model.isClassModeled(interfc) || !(interfcDesc = model.getClassDescriptor(interfc)).declaresField(refName)) continue;
                        model.createDependencyEdge(md, interfcDesc.getField(refName), EdgeType.REFERENCES);
                        declarationFound = true;
                    }
                } else {
                    declarationFound = true;
                }
                owner = model.getClassDescriptor(owner.getSuperName());
            }
            if (!owner.declaresField(refName)) continue;
            model.createDependencyEdge(md, owner.getField(refName), EdgeType.REFERENCES);
            this.checkLegacyDotClassField(refName, owner, model);
        }
    }

    private void checkLegacyDotClassField(String refName, ClassDescriptor owner, Model model) {
        FieldDescriptor fd;
        if (refName.startsWith(SYNTHETIC_DOT_CLASS_FIELD_START) && CLASS_DESC.equals((fd = owner.getField(refName)).getDesc()) && fd.isSynthetic()) {
            StringBuilder[] possibleClassNames;
            for (StringBuilder possibleClassName : possibleClassNames = this.getPossibleClassNames(refName)) {
                String className = possibleClassName.toString();
                if (!model.isClassModeled(className)) continue;
                ClassDescriptor cd = model.getClassDescriptor(className);
                model.createDependencyEdge(fd, cd, EdgeType.RESOLVE);
            }
        }
    }

    private StringBuilder[] getPossibleClassNames(String fieldName) {
        int i;
        String[] toks = fieldName.substring(6).split("\\$");
        StringBuilder[] possibleClassNames = new StringBuilder[toks.length];
        for (i = 0; i < possibleClassNames.length; ++i) {
            possibleClassNames[i] = new StringBuilder();
            possibleClassNames[i].append(toks[0]);
        }
        for (i = 1; i < toks.length; ++i) {
            int j;
            for (j = i - 1; j >= 0; --j) {
                possibleClassNames[j].append("$").append(toks[i]);
            }
            for (j = 0; j < i; ++j) {
                possibleClassNames[i].append("/").append(toks[j + 1]);
            }
        }
        return possibleClassNames;
    }
}

