/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yshrink.core;

import com.yworks.util.graph.Network;
import java.util.HashMap;
import java.util.Map;

public class Dfs {
    private Map<Object, Object> edgeVisit;
    private int dfsNum;
    private int compNum;
    private Network network;
    private boolean directedMode = false;
    protected Map<Object, Object> stateMap;
    protected static Object WHITE = null;
    protected static Object GRAY = new Object();
    protected static Object BLACK = new Object();
    private byte[] nextState = new byte[1];

    public void setDirectedMode(boolean directed) {
        this.directedMode = directed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Network network, Object start) {
        if (null == start) {
            return;
        }
        this.network = network;
        this.stateMap = new HashMap<Object, Object>();
        if (!this.directedMode) {
            this.edgeVisit = new HashMap<Object, Object>();
        }
        this.dfsNum = 0;
        this.compNum = 0;
        int stackSize = Math.min(60, network.nodesSize() + 3);
        Stack stack = new Stack(stackSize);
        try {
            this.workStack(stack, start);
        }
        finally {
            this.stateMap.clear();
            if (!this.directedMode) {
                this.edgeVisit.clear();
            }
        }
    }

    private Object nextEdge(Object currentNode, Object currentEdge, byte[] currentMode) {
        switch (currentMode[0]) {
            case 0: {
                if (this.directedMode) {
                    currentMode[0] = 1;
                    return this.network.firstOutEdge(currentNode);
                }
                Object edge = this.network.firstOutEdge(currentNode);
                if (edge == null) {
                    edge = this.network.firstInEdge(currentNode);
                    currentMode[0] = 3;
                } else {
                    currentMode[0] = 2;
                }
                return edge;
            }
            case 1: {
                return this.network.nextOutEdge(currentEdge);
            }
            case 2: {
                Object edge = this.network.nextOutEdge(currentEdge);
                if (edge == null) {
                    edge = this.network.firstInEdge(currentNode);
                    currentMode[0] = 3;
                }
                return edge;
            }
            case 3: {
                return this.network.nextInEdge(currentEdge);
            }
        }
        throw new InternalError();
    }

    private Object doNextEdge(Object currentNode, Object currentEdge, byte[] currentMode) {
        Object edge = this.nextEdge(currentNode, currentEdge, currentMode);
        while (edge != null && !this.doTraverse(edge)) {
            edge = this.nextEdge(currentNode, edge, currentMode);
        }
        return edge;
    }

    private void workStack(Stack stack, Object start) {
        this.nextState[0] = 0;
        Object currentNode = start;
        this.stateMap.put(currentNode, GRAY);
        this.preVisit(currentNode, ++this.dfsNum);
        Object nextEdge = this.doNextEdge(currentNode, null, this.nextState);
        stack.pushState(currentNode, nextEdge, this.nextState[0], this.dfsNum);
        while (!stack.isEmpty()) {
            Object edge = stack.peekCurrentEdge();
            this.nextState[0] = stack.peekIteratorState();
            while (edge != null) {
                if (this.directedMode || !((Boolean)this.edgeVisit.get(edge)).booleanValue()) {
                    Object other;
                    if (!this.directedMode) {
                        this.edgeVisit.put(edge, true);
                        other = this.network.opposite(edge, currentNode);
                    } else {
                        other = this.network.getTarget(edge);
                    }
                    if (this.stateMap.get(other) == null) {
                        this.preTraverse(edge, other, true);
                        this.stateMap.put(other, GRAY);
                        currentNode = other;
                        this.preVisit(currentNode, ++this.dfsNum);
                        this.nextState[0] = 0;
                        edge = this.doNextEdge(currentNode, null, this.nextState);
                        stack.pushState(currentNode, edge, this.nextState[0], this.dfsNum);
                        continue;
                    }
                    this.preTraverse(edge, other, false);
                    edge = this.doNextEdge(currentNode, edge, this.nextState);
                    stack.updateTop(edge, this.nextState[0]);
                    continue;
                }
                edge = this.doNextEdge(currentNode, edge, this.nextState);
                stack.updateTop(edge, this.nextState[0]);
            }
            this.postVisit(currentNode, stack.peekLocalDfsNum(), ++this.compNum);
            this.stateMap.put(currentNode, BLACK);
            stack.pop();
            if (stack.isEmpty()) continue;
            Object currentEdge = stack.peekCurrentEdge();
            this.postTraverse(currentEdge, currentNode);
            currentNode = stack.peekNode();
            this.nextState[0] = stack.peekIteratorState();
            Object nextEdge2 = this.doNextEdge(currentNode, currentEdge, this.nextState);
            stack.updateTop(nextEdge2, this.nextState[0]);
        }
    }

    protected void preVisit(Object node, int dfsNumber) {
    }

    protected void postVisit(Object node, int dfsNumber, int compNumber) {
    }

    protected boolean preTraverse(Object edge, Object node, boolean treeEdge) {
        return true;
    }

    protected void postTraverse(Object edge, Object node) {
    }

    protected boolean doTraverse(Object e) {
        return true;
    }

    static class Stack {
        int stackIndex = -1;
        byte[] iteratorStates;
        Object[] currentEdges;
        int[] localDfsNums;
        Object[] nodes;

        Stack(int initialSize) {
            this.localDfsNums = new int[initialSize];
            this.currentEdges = new Object[initialSize];
            this.iteratorStates = new byte[initialSize];
            this.nodes = new Object[initialSize];
        }

        boolean isEmpty() {
            return this.stackIndex < 0;
        }

        void pop() {
            --this.stackIndex;
        }

        Object peekNode() {
            return this.nodes[this.stackIndex];
        }

        Object peekCurrentEdge() {
            return this.currentEdges[this.stackIndex];
        }

        byte peekIteratorState() {
            return this.iteratorStates[this.stackIndex];
        }

        int peekLocalDfsNum() {
            return this.localDfsNums[this.stackIndex];
        }

        int pushState(Object node, Object currentEdge, byte iterastorState, int localDfsNum) {
            ++this.stackIndex;
            if (this.stackIndex == this.nodes.length) {
                int newSize = (this.stackIndex + 1) * 2;
                Object[] newStack = new Object[newSize];
                System.arraycopy(this.nodes, 0, newStack, 0, this.nodes.length);
                this.nodes = newStack;
                Object[] newEStack = new Object[newSize];
                System.arraycopy(this.currentEdges, 0, newEStack, 0, this.currentEdges.length);
                this.currentEdges = newEStack;
                int[] newDStack = new int[newSize];
                System.arraycopy(this.localDfsNums, 0, newDStack, 0, this.localDfsNums.length);
                this.localDfsNums = newDStack;
                byte[] newStateStack = new byte[newSize];
                System.arraycopy(this.iteratorStates, 0, newStateStack, 0, this.iteratorStates.length);
                this.iteratorStates = newStateStack;
            }
            this.nodes[this.stackIndex] = node;
            this.currentEdges[this.stackIndex] = currentEdge;
            this.iteratorStates[this.stackIndex] = iterastorState;
            this.localDfsNums[this.stackIndex] = localDfsNum;
            return this.localDfsNums[this.stackIndex];
        }

        void updateTop(Object currentEdge, byte iteratorState) {
            this.currentEdges[this.stackIndex] = currentEdge;
            this.iteratorStates[this.stackIndex] = iteratorState;
        }
    }
}

