/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yshrink.model;

import com.yworks.yshrink.model.AbstractDescriptor;
import com.yworks.yshrink.model.AnnotationUsage;
import com.yworks.yshrink.model.ClassDescriptor;
import com.yworks.yshrink.model.MethodDescriptor;
import com.yworks.yshrink.model.Model;
import java.io.File;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ModelVisitor
extends ClassVisitor {
    static final int OPCODES_ASM = 458752;
    private Model model;
    private ClassDescriptor currentClass;
    private final File sourceJar;

    public ModelVisitor(Model model, File sourceJar) {
        super(458752);
        this.model = model;
        this.sourceJar = sourceJar;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (!this.model.isClassModeled(name)) {
            this.currentClass = this.model.newClassDescriptor(name, superName, interfaces, access, this.sourceJar);
        } else {
            this.currentClass = this.model.getClassDescriptor(name);
            this.currentClass.setInterfaces(interfaces);
            this.currentClass.setSuperName(superName);
        }
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    @Override
    public void visitNestMember(String nestMember) {
        this.currentClass.setHasNestMembers(true);
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        if (name != null) {
            this.currentClass.setEnclosingMethod(name, desc);
            this.currentClass.setEnclosingClass(owner);
        } else {
            this.currentClass.setEnclosingClass(owner);
        }
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.model.newFieldDescriptor(this.currentClass, desc, name, access, this.sourceJar);
        return null;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodDescriptor currentMethod = this.model.newMethodDescriptor(this.currentClass, access, name, desc, exceptions, this.sourceJar);
        return new ModelMethodVisitor(currentMethod);
    }

    @Override
    public void visitSource(String source, String debug) {
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return new ModelAnnotationVisitor(this.currentClass, this.currentClass.addAnnotation(desc));
    }

    @Override
    public void visitAttribute(Attribute attr) {
    }

    @Override
    public void visitEnd() {
    }

    class ModelAnnotationVisitor
    extends AnnotationVisitor {
        private final AbstractDescriptor currentItem;
        private final AnnotationUsage annotationUsage;

        public ModelAnnotationVisitor(AbstractDescriptor currentItem, AnnotationUsage annotationUsage) {
            super(458752);
            this.currentItem = currentItem;
            this.annotationUsage = annotationUsage;
        }

        @Override
        public void visit(String name, Object value) {
            this.annotationUsage.addFieldUsage(name);
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            this.annotationUsage.addFieldUsage(name);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            this.annotationUsage.addFieldUsage(name);
            return new ModelAnnotationVisitor(this.currentItem, this.currentItem.addAnnotation(desc));
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            this.annotationUsage.addFieldUsage(name);
            return new ModelAnnotationVisitor(this.currentItem, new AnnotationUsage("array"));
        }

        @Override
        public void visitEnd() {
        }
    }

    class ModelMethodVisitor
    extends MethodVisitor {
        private MethodDescriptor currentMethod;

        public ModelMethodVisitor(MethodDescriptor currentMethod) {
            super(458752);
            this.currentMethod = currentMethod;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            this.currentMethod.addInvocation(opcode, owner, name, desc);
        }

        @Override
        public void visitTypeInsn(int opcode, String desc) {
            this.currentMethod.addTypeInstruction(opcode, desc);
        }

        @Override
        public void visitMultiANewArrayInsn(String desc, int dims) {
            this.currentMethod.addTypeInstruction(197, desc);
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            this.currentMethod.addFieldRef(owner, name);
        }

        @Override
        public AnnotationVisitor visitAnnotationDefault() {
            return new ModelAnnotationVisitor(this.currentMethod, new AnnotationUsage("java.lang.AnnotationDefaultAttribute"));
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new ModelAnnotationVisitor(this.currentMethod, this.currentMethod.addAnnotation(desc));
        }

        @Override
        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return new ModelAnnotationVisitor(this.currentMethod, this.currentMethod.addAnnotation(desc));
        }

        @Override
        public void visitAttribute(Attribute attr) {
        }

        @Override
        public void visitCode() {
        }

        @Override
        public void visitFrame(int i, int i1, Object[] objects, int i2, Object[] objects1) {
        }

        @Override
        public void visitInsn(int opcode) {
        }

        @Override
        public void visitIntInsn(int opcode, int operand) {
        }

        @Override
        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            if (bootstrapMethodHandle.getOwner().equals("java/lang/invoke/LambdaMetafactory")) {
                String className = descriptor.substring(descriptor.indexOf(")L") + 2, descriptor.length() - 1);
                Type methodDescriptor = (Type)bootstrapMethodArguments[0];
                Handle callerHandle = (Handle)bootstrapMethodArguments[1];
                this.currentMethod.addInvocation(186, className, name, methodDescriptor.getDescriptor());
                this.currentMethod.addInvocation(186, callerHandle.getOwner(), callerHandle.getName(), callerHandle.getDesc());
            }
        }

        @Override
        public void visitVarInsn(int opcode, int var) {
        }

        @Override
        public void visitJumpInsn(int opcode, Label label) {
        }

        @Override
        public void visitLabel(Label label) {
        }

        @Override
        public void visitLdcInsn(Object cst) {
            if (cst instanceof Type) {
                Type type = (Type)cst;
                this.currentMethod.addTypeInstruction(18, type.getDescriptor());
            }
        }

        @Override
        public void visitIincInsn(int var, int increment) {
        }

        @Override
        public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        }

        @Override
        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        }

        @Override
        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        }

        @Override
        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        }

        @Override
        public void visitLineNumber(int line, Label start) {
        }

        @Override
        public void visitMaxs(int maxStack, int maxLocals) {
        }

        @Override
        public void visitEnd() {
        }
    }
}

