/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.cache;

import fr.fuzeblocks.homeplugin.HomePlugin;
import fr.fuzeblocks.homeplugin.home.HomeManager;
import fr.fuzeblocks.homeplugin.home.HomeRequestStore;
import fr.fuzeblocks.homeplugin.home.LocalHomeStore;
import fr.fuzeblocks.homeplugin.home.RedisHomeStore;
import fr.fuzeblocks.homeplugin.rtp.LocalRtpRequestStore;
import fr.fuzeblocks.homeplugin.rtp.RedisRtpRequestStore;
import fr.fuzeblocks.homeplugin.rtp.RtpRequestStore;
import fr.fuzeblocks.homeplugin.spawn.LocalSpawnStore;
import fr.fuzeblocks.homeplugin.spawn.RedisSpawnStore;
import fr.fuzeblocks.homeplugin.spawn.SpawnRequestStore;
import fr.fuzeblocks.homeplugin.tpa.LocalTpaRequestStore;
import fr.fuzeblocks.homeplugin.tpa.RedisTpaRequestStore;
import fr.fuzeblocks.homeplugin.tpa.TpaRequestStore;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import redis.clients.jedis.JedisPooled;

public class CacheManager {
    private static CacheManager instance;
    private final boolean useRedis = HomePlugin.getConfigurationSection().getBoolean("Config.Connector.Redis.UseRedis");
    private final JedisPooled jedis;
    private final TpaRequestStore tpaRequestStore;
    private final HomeRequestStore homeStore;
    private final SpawnRequestStore spawnStore;
    private final RtpRequestStore rtpRequestStore;

    private CacheManager() {
        JedisPooled jedisPooled = this.jedis = this.useRedis ? HomePlugin.getJedisPooled() : null;
        if (this.useRedis) {
            this.tpaRequestStore = new RedisTpaRequestStore(this.jedis);
            this.homeStore = new RedisHomeStore(this.jedis);
            this.spawnStore = new RedisSpawnStore(this.jedis);
            this.rtpRequestStore = new RedisRtpRequestStore(this.jedis);
        } else {
            this.tpaRequestStore = new LocalTpaRequestStore();
            this.homeStore = new LocalHomeStore();
            this.spawnStore = new LocalSpawnStore();
            this.rtpRequestStore = new LocalRtpRequestStore();
        }
    }

    public static synchronized CacheManager getInstance() {
        if (instance == null) {
            instance = new CacheManager();
        }
        return instance;
    }

    public void addTpaRequest(UUID sender, UUID target) {
        this.tpaRequestStore.addTpaRequest(sender, target);
    }

    public boolean hasTpaRequest(UUID sender, UUID target) {
        return this.tpaRequestStore.hasTpaRequest(sender, target);
    }

    public void removeTpaRequest(UUID sender, UUID target) {
        this.tpaRequestStore.removeTpaRequest(sender, target);
    }

    public UUID getTargetWithSender(UUID sender) {
        return this.tpaRequestStore.getTargetWithSender(sender);
    }

    public boolean hasIncomingTpa(UUID target) {
        return this.tpaRequestStore.hasIncomingTpa(target);
    }

    public UUID getSenderForTarget(UUID target) {
        return this.tpaRequestStore.getSenderForTarget(target);
    }

    public UUID getTpaTarget(UUID senderId) {
        return this.tpaRequestStore.getTpaTarget(senderId);
    }

    public Set<UUID> getAllTpaSenders() {
        return this.tpaRequestStore.getAllTpaSenders();
    }

    public void addHome(UUID playerId, String homeName, Location location) {
        this.homeStore.addHome(playerId, homeName, location);
    }

    public void removeHome(UUID playerId, String homeName) {
        this.homeStore.removeHome(playerId, homeName);
    }

    public void relocateHome(UUID playerId, String homeName, Location newLocation) {
        this.homeStore.removeHome(playerId, homeName);
    }

    public Map<String, Location> getHomes(UUID playerId) {
        return this.homeStore.getHomes(playerId);
    }

    public void clearHomes(UUID playerId) {
        this.homeStore.clearHomes(playerId);
    }

    public void clearAllHomes() {
        this.homeStore.clearAllHomes();
    }

    public void loadAllHomesToCache(Player player) {
        HomeManager homeManager = HomePlugin.getHomeManager();
        for (String homeName : homeManager.getHomesName(player)) {
            System.out.println("Loading home '" + homeName + "' for player " + player.getName() + " into cache.");
            assert (homeName != null);
            assert (homeManager.exist(player, homeName));
            Location location = homeManager.getHomeLocation(player, homeName);
            this.addHome(player.getUniqueId(), homeName, location);
        }
    }

    public void setSpawn(Location location) {
        this.spawnStore.setSpawn(location);
    }

    public Location getSpawn() {
        return this.spawnStore.getSpawn();
    }

    public void clearSpawn() {
        this.spawnStore.clearSpawn();
    }

    public void addRtpRequest(UUID playerId, Long timestamp) {
        this.rtpRequestStore.addRtpRequest(playerId, timestamp);
    }

    public Long getRtpRequest(UUID playerId) {
        return this.rtpRequestStore.getRtpRequest(playerId);
    }

    public void removeRtpRequest(UUID playerId) {
        this.rtpRequestStore.removeRtpRequest(playerId);
    }

    public boolean hasRtpRequest(UUID playerId) {
        return this.rtpRequestStore.hasRtpRequest(playerId);
    }

    public Map<UUID, Long> getAllRtpRequests() {
        return this.rtpRequestStore.getAllRtpRequests();
    }

    public boolean isUsingRedis() {
        return this.useRedis;
    }
}

