/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.commands;

import fr.fuzeblocks.homeplugin.HomePlugin;
import fr.fuzeblocks.homeplugin.back.BackManager;
import fr.fuzeblocks.homeplugin.language.LanguageManager;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

public class BackCommand
implements CommandExecutor {
    private static final String PERM_USE = "homeplugin.back.use";
    private static final String LANG = "Language.";
    private static final String BACK = "Back.";
    private final BackManager backManager = BackManager.getInstance();
    private final LanguageManager languageManager = HomePlugin.getLanguageManager();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.languageManager.getStringWithColor("Language.Only-a-player-can-execute"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERM_USE)) {
            player.sendMessage(this.languageManager.getStringWithColor("Language.No-permission"));
            return true;
        }
        if (!this.backManager.hasLastLocation(player)) {
            player.sendMessage(this.languageManager.getStringWithColor("Back.No-previous-location"));
            return true;
        }
        Location current = player.getLocation().clone();
        Location target = this.backManager.getLastLocation(player).orElse(null);
        if (target == null || target.getWorld() == null) {
            player.sendMessage(this.languageManager.getStringWithColor("Back.Previous-location-invalid"));
            return true;
        }
        this.backManager.setLastLocation(player, current);
        boolean success = player.teleport(target, PlayerTeleportEvent.TeleportCause.PLUGIN);
        if (success) {
            player.sendMessage(this.languageManager.getStringWithColor("Back.Teleported"));
        } else {
            player.sendMessage(this.languageManager.getStringWithColor("Back.Teleport-failed"));
        }
        return true;
    }
}

