/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.commands;

import fr.fuzeblocks.homeplugin.HomePlugin;
import fr.fuzeblocks.homeplugin.cache.CacheManager;
import fr.fuzeblocks.homeplugin.home.HomeManager;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CacheCommand
implements CommandExecutor {
    private static final String LANG = "Language.";
    private static final String CACHE = "Cache.";

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            this.sendMsg(sender, "Language.Only-a-player-can-execute");
            return false;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("homeplugin.admin")) {
            this.sendMsg((CommandSender)player, "Language.No-permission");
            return false;
        }
        CacheManager cacheManager = HomePlugin.getCacheManager();
        HomeManager homeManager = HomePlugin.getHomeManager();
        if (args.length < 1) {
            this.sendUsageMessage(player);
            return false;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "clearall": {
                this.handleClearAll(player, cacheManager);
                break;
            }
            case "view": {
                if (args.length < 2) {
                    this.sendMsg((CommandSender)player, "Cache.Cache-view-usage-command");
                    return false;
                }
                this.handleViewCache(player, args[1], cacheManager, homeManager);
                break;
            }
            default: {
                this.handleClearPlayer(player, args[0], cacheManager);
            }
        }
        return true;
    }

    private void sendUsageMessage(Player player) {
        player.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        String title = this.translate("Cache.Cache-management-title");
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("         " + title)));
        player.sendMessage("");
        String usageIcon = ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)this.translate("Cache.Cache-usage-icon")));
        TextComponent viewCmd = new TextComponent("  " + usageIcon + " ");
        viewCmd.setColor(ChatColor.DARK_GRAY);
        TextComponent viewText = new TextComponent("/cache view <player>");
        viewText.setColor(ChatColor.YELLOW);
        viewText.setBold(Boolean.valueOf(false));
        viewText.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/cache view "));
        String viewHover = this.translate("Cache.Cache-click-suggest");
        viewText.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(ChatColor.stripColor((String)viewHover)).color(ChatColor.GRAY).create()));
        String viewDesc = this.translate("Cache.Cache-view-description");
        TextComponent viewDescComp = new TextComponent(" - " + ChatColor.stripColor((String)viewDesc));
        viewDescComp.setColor(ChatColor.GRAY);
        viewCmd.addExtra((BaseComponent)viewText);
        viewCmd.addExtra((BaseComponent)viewDescComp);
        player.spigot().sendMessage((BaseComponent)viewCmd);
        TextComponent clearAllCmd = new TextComponent("  " + usageIcon + " ");
        clearAllCmd.setColor(ChatColor.DARK_GRAY);
        TextComponent clearAllText = new TextComponent("/cache clearall");
        clearAllText.setColor(ChatColor.RED);
        clearAllText.setBold(Boolean.valueOf(false));
        clearAllText.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/cache clearall"));
        String clearAllHover = this.translate("Cache.Cache-click-suggest");
        String clearAllWarning = this.translate("Cache.Cache-clearall-warning");
        clearAllText.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(ChatColor.stripColor((String)clearAllHover)).color(ChatColor.GRAY).append("\n").append(ChatColor.stripColor((String)clearAllWarning)).color(ChatColor.RED).bold(true).create()));
        String clearAllDesc = this.translate("Cache.Cache-clearall-description");
        TextComponent clearAllDescComp = new TextComponent(" - " + ChatColor.stripColor((String)clearAllDesc));
        clearAllDescComp.setColor(ChatColor.GRAY);
        clearAllCmd.addExtra((BaseComponent)clearAllText);
        clearAllCmd.addExtra((BaseComponent)clearAllDescComp);
        player.spigot().sendMessage((BaseComponent)clearAllCmd);
        TextComponent clearPlayerCmd = new TextComponent("  " + usageIcon + " ");
        clearPlayerCmd.setColor(ChatColor.DARK_GRAY);
        TextComponent clearPlayerText = new TextComponent("/cache <player>");
        clearPlayerText.setColor(ChatColor.GOLD);
        clearPlayerText.setBold(Boolean.valueOf(false));
        clearPlayerText.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/cache "));
        String clearPlayerHover = this.translate("Cache.Cache-click-suggest");
        clearPlayerText.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(ChatColor.stripColor((String)clearPlayerHover)).color(ChatColor.GRAY).create()));
        String clearPlayerDesc = this.translate("Cache.Cache-clear-player-description");
        TextComponent clearPlayerDescComp = new TextComponent(" - " + ChatColor.stripColor((String)clearPlayerDesc));
        clearPlayerDescComp.setColor(ChatColor.GRAY);
        clearPlayerCmd.addExtra((BaseComponent)clearPlayerText);
        clearPlayerCmd.addExtra((BaseComponent)clearPlayerDescComp);
        player.spigot().sendMessage((BaseComponent)clearPlayerCmd);
        player.sendMessage("");
        player.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
    }

    private void handleClearAll(Player player, CacheManager cacheManager) {
        cacheManager.clearAllHomes();
        String message = this.translate("Cache.Cache-all-cleared-success");
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
    }

    private void handleClearPlayer(Player player, String targetName, CacheManager cacheManager) {
        Player targetToClear = Bukkit.getPlayerExact((String)targetName);
        if (targetToClear == null) {
            this.sendMsg((CommandSender)player, "Language.Player-is-not-online");
            return;
        }
        cacheManager.clearHomes(targetToClear.getUniqueId());
        String message = this.translate("Cache.Cache-player-cleared-success").replace("{player}", targetToClear.getName());
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
    }

    private void handleViewCache(Player player, String targetName, CacheManager cacheManager, HomeManager homeManager) {
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null) {
            this.sendMsg((CommandSender)player, "Language.Player-is-not-online");
            return;
        }
        Map<String, Location> homes = cacheManager.getHomes(target.getUniqueId());
        if (homes == null || homes.isEmpty()) {
            String message = this.translate("Cache.Cache-player-empty").replace("{player}", target.getName());
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
            return;
        }
        player.sendMessage("");
        player.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        String headerText = this.translate("Cache.Cache-player-homes-title").replace("{player}", target.getName());
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)headerText));
        String countText = this.translate("Cache.Cache-total-label").replace("{count}", String.valueOf(homes.size()));
        player.sendMessage("              " + ChatColor.translateAlternateColorCodes((char)'&', (String)countText));
        player.sendMessage("");
        for (String homeName : homeManager.getHomesName(target)) {
            this.sendInteractiveHomeMessage(homes, homeName, player, target);
        }
        player.sendMessage("");
        player.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
    }

    private void sendInteractiveHomeMessage(Map<String, Location> homes, String homeName, Player player, Player target) {
        Location homeLocation = homes.get(homeName);
        if (homeLocation == null) {
            return;
        }
        String homeIconRaw = this.translate("Cache.Cache-home-icon");
        String homeIcon = ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)homeIconRaw));
        TextComponent homeEntry = new TextComponent("  " + homeIcon + " ");
        homeEntry.setColor(ChatColor.YELLOW);
        TextComponent nameComponent = new TextComponent(homeName);
        nameComponent.setColor(ChatColor.AQUA);
        nameComponent.setBold(Boolean.valueOf(true));
        homeEntry.addExtra((BaseComponent)nameComponent);
        player.spigot().sendMessage((BaseComponent)homeEntry);
        String locIconRaw = this.translate("Cache.Cache-location-icon");
        String locIcon = ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)locIconRaw));
        TextComponent locationLine = new TextComponent("     " + locIcon + " ");
        locationLine.setColor(ChatColor.GRAY);
        TextComponent coords = new TextComponent(String.format("%.1f, %.1f, %.1f", homeLocation.getX(), homeLocation.getY(), homeLocation.getZ()));
        coords.setColor(ChatColor.GREEN);
        String worldLabel = this.translate("Cache.Cache-world-label").replace("{world}", homeLocation.getWorld().getName());
        TextComponent world = new TextComponent(" " + ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)worldLabel)));
        world.setColor(ChatColor.DARK_GRAY);
        locationLine.addExtra((BaseComponent)coords);
        locationLine.addExtra((BaseComponent)world);
        player.spigot().sendMessage((BaseComponent)locationLine);
        TextComponent buttonLine = new TextComponent("     ");
        String buttonText = this.translate("Cache.Cache-teleport-button");
        TextComponent button = new TextComponent(ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)buttonText)));
        button.setColor(ChatColor.YELLOW);
        button.setBold(Boolean.valueOf(true));
        button.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp " + homeLocation.getBlockX() + " " + homeLocation.getBlockY() + " " + homeLocation.getBlockZ()));
        String hoverText = this.translate("Cache.Cache-teleport-hover");
        String xLabel = this.translate("Cache.Cache-coord-label-x");
        String yLabel = this.translate("Cache.Cache-coord-label-y");
        String zLabel = this.translate("Cache.Cache-coord-label-z");
        button.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)hoverText))).color(ChatColor.GRAY).append("\n").append(ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)xLabel))).color(ChatColor.DARK_GRAY).append(" ").append(String.format("%.1f", homeLocation.getX())).color(ChatColor.GREEN).append("\n").append(ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)yLabel))).color(ChatColor.DARK_GRAY).append(" ").append(String.format("%.1f", homeLocation.getY())).color(ChatColor.GREEN).append("\n").append(ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)zLabel))).color(ChatColor.DARK_GRAY).append(" ").append(String.format("%.1f", homeLocation.getZ())).color(ChatColor.GREEN).create()));
        buttonLine.addExtra((BaseComponent)button);
        player.spigot().sendMessage((BaseComponent)buttonLine);
        player.sendMessage("");
    }

    private void sendMsg(CommandSender sender, String path) {
        sender.sendMessage(this.translate(path));
    }

    private String translate(String path) {
        return HomePlugin.getLanguageManager().getStringWithColor(path);
    }
}

