/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.commands.home;

import fr.fuzeblocks.homeplugin.HomePlugin;
import fr.fuzeblocks.homeplugin.home.HomeManager;
import fr.fuzeblocks.homeplugin.language.LanguageManager;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class HomeAdminCommand
implements CommandExecutor {
    private static final String LANG = "Language.";
    private static final String ADMIN = "HomeAdmin.";
    private static final LanguageManager languageManager = HomePlugin.getLanguageManager();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.sendMsg(sender, "Language.Only-a-player-can-execute");
            return false;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("homeplugin.admin")) {
            this.sendMsg((CommandSender)player, "Language.No-permission");
            return false;
        }
        if (args.length < 1) {
            this.sendUsage(player);
            return false;
        }
        String subCommand = args[0].toLowerCase();
        HomeManager homeManager = HomePlugin.getHomeManager();
        switch (subCommand) {
            case "list": {
                if (args.length < 2) {
                    this.sendMsg((CommandSender)player, "HomeAdmin.List-usage");
                    return false;
                }
                return this.listHomes(player, args[1], homeManager);
            }
            case "deletehome": {
                if (args.length < 3) {
                    this.sendMsg((CommandSender)player, "HomeAdmin.DeleteHome-usage");
                    return false;
                }
                return this.deleteHome(player, args[1], args[2], homeManager);
            }
            case "tphome": {
                if (args.length < 3) {
                    this.sendMsg((CommandSender)player, "HomeAdmin.TpHome-usage");
                    return false;
                }
                return this.teleportToHome(player, args[1], args[2], homeManager);
            }
            case "addhome": {
                if (args.length < 3) {
                    this.sendMsg((CommandSender)player, "HomeAdmin.AddHome-usage");
                    return false;
                }
                return this.addHome(player, args[1], args[2], homeManager);
            }
        }
        this.sendUsage(player);
        return false;
    }

    private boolean listHomes(Player player, String targetName, HomeManager homeManager) {
        Player target = Bukkit.getPlayerExact((String)targetName);
        if (target == null) {
            this.sendErrorMessage(player, this.translate("Language.Player-is-not-online"));
            return false;
        }
        List<String> homeNames = homeManager.getHomesName(target);
        if (homeNames == null || homeNames.isEmpty()) {
            this.sendErrorMessage(player, languageManager.getStringWithColor("HomeAdmin.ListHome-has-no-homes").replace("%player%", target.getName()));
            return false;
        }
        player.sendMessage("");
        player.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        TextComponent header = new TextComponent("         ");
        TextComponent playerHeader = new TextComponent(languageManager.getStringWithColor("HomeAdmin.Home-list-header").replace("%player%", target.getName()));
        playerHeader.setColor(ChatColor.GOLD);
        playerHeader.setBold(Boolean.valueOf(true));
        header.addExtra((BaseComponent)playerHeader);
        player.spigot().sendMessage((BaseComponent)header);
        TextComponent count = new TextComponent("              ");
        TextComponent countText = new TextComponent(languageManager.getStringWithColor("HomeAdmin.Home-count").replace("%count%", String.valueOf(homeNames.size())));
        countText.setColor(ChatColor.GRAY);
        count.addExtra((BaseComponent)countText);
        player.spigot().sendMessage((BaseComponent)count);
        player.sendMessage("");
        for (String homeName : homeNames) {
            Location loc;
            if (homeName == null || (loc = homeManager.getHomeLocation(target, homeName)) == null) continue;
            this.sendInteractiveHomeEntry(player, target, homeName, loc);
        }
        player.sendMessage("");
        player.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        return true;
    }

    private void sendInteractiveHomeEntry(Player admin, Player target, String homeName, Location location) {
        TextComponent homeEntry = new TextComponent(languageManager.getStringWithColor("HomeAdmin.Home-icon"));
        homeEntry.setColor(ChatColor.YELLOW);
        TextComponent nameComponent = new TextComponent(homeName);
        nameComponent.setColor(ChatColor.AQUA);
        nameComponent.setBold(Boolean.valueOf(true));
        homeEntry.addExtra((BaseComponent)nameComponent);
        admin.spigot().sendMessage((BaseComponent)homeEntry);
        TextComponent locationLine = new TextComponent("     ");
        TextComponent locIcon = new TextComponent("\u25cf ");
        locIcon.setColor(ChatColor.GRAY);
        TextComponent coords = new TextComponent(String.format("%.1f, %.1f, %.1f", location.getX(), location.getY(), location.getZ()));
        coords.setColor(ChatColor.GREEN);
        TextComponent world = new TextComponent(" (" + location.getWorld().getName() + ")");
        world.setColor(ChatColor.DARK_GRAY);
        locationLine.addExtra((BaseComponent)locIcon);
        locationLine.addExtra((BaseComponent)coords);
        locationLine.addExtra((BaseComponent)world);
        admin.spigot().sendMessage((BaseComponent)locationLine);
        TextComponent buttonLine = new TextComponent("     ");
        TextComponent tpButton = new TextComponent("[\u1d1b\u1d18]");
        tpButton.setColor(ChatColor.GREEN);
        tpButton.setBold(Boolean.valueOf(true));
        tpButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/homeadmin tphome " + target.getName() + " " + homeName));
        tpButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(languageManager.getString("HomeAdmin.Click-to-teleport")).color(ChatColor.GRAY).create()));
        TextComponent space = new TextComponent("  ");
        TextComponent delButton = new TextComponent("[\u1d05\u1d07\u029f\u1d07\u1d1b\u1d07]");
        delButton.setColor(ChatColor.RED);
        delButton.setBold(Boolean.valueOf(true));
        delButton.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/homeadmin deletehome " + target.getName() + " " + homeName));
        delButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(languageManager.getString("HomeAdmin.Click-to-delete") + "\n").color(ChatColor.GRAY).append(languageManager.getString("HomeAdmin.Click-to-delete-warning")).color(ChatColor.YELLOW).create()));
        buttonLine.addExtra((BaseComponent)tpButton);
        buttonLine.addExtra((BaseComponent)space);
        buttonLine.addExtra((BaseComponent)delButton);
        admin.spigot().sendMessage((BaseComponent)buttonLine);
        admin.sendMessage("");
    }

    private boolean deleteHome(Player admin, String targetName, String homeName, HomeManager homeManager) {
        Player target = Bukkit.getPlayerExact((String)targetName);
        if (target == null) {
            this.sendErrorMessage(admin, this.translate("Language.Player-is-not-online"));
            return false;
        }
        Location homeLocation = homeManager.getHomeLocation(target, homeName);
        if (homeLocation == null) {
            this.sendErrorMessage(admin, languageManager.getStringWithColor("HomeAdmin.Home-not-found-admin").replace("%home%", homeName).replace("%player%", target.getName()));
            return false;
        }
        boolean deleted = homeManager.deleteHome(target, homeName);
        if (deleted) {
            HomePlugin.getCacheManager().removeHome(target.getUniqueId(), homeName);
            TextComponent message = new TextComponent("\u2713 ");
            message.setColor(ChatColor.GREEN);
            message.setBold(Boolean.valueOf(true));
            TextComponent text = new TextComponent(languageManager.getStringWithColor("HomeAdmin.DeleteHome-text") + " ");
            text.setColor(ChatColor.GREEN);
            text.setBold(Boolean.valueOf(false));
            TextComponent home = new TextComponent(homeName);
            home.setColor(ChatColor.AQUA);
            home.setBold(Boolean.valueOf(true));
            TextComponent from = new TextComponent(" " + languageManager.getString("DeleteHome-from-player") + " ");
            from.setColor(ChatColor.GREEN);
            from.setBold(Boolean.valueOf(false));
            TextComponent player = new TextComponent(target.getName());
            player.setColor(ChatColor.YELLOW);
            player.setBold(Boolean.valueOf(true));
            message.addExtra((BaseComponent)text);
            message.addExtra((BaseComponent)home);
            message.addExtra((BaseComponent)from);
            message.addExtra((BaseComponent)player);
            admin.spigot().sendMessage((BaseComponent)message);
            return true;
        }
        this.sendErrorMessage(admin, languageManager.getStringWithColor("HomeAdmin.Failed-to-delete-home").replace("%home%", homeName).replace("%player%", target.getName()));
        return false;
    }

    private boolean teleportToHome(Player admin, String targetName, String homeName, HomeManager homeManager) {
        Player target = Bukkit.getPlayerExact((String)targetName);
        if (target == null) {
            this.sendErrorMessage(admin, this.translate("Language.Player-is-not-online"));
            return false;
        }
        Location loc = homeManager.getHomeLocation(target, homeName);
        if (loc == null) {
            this.sendErrorMessage(admin, languageManager.getStringWithColor("HomeAdmin.Home-not-found-admin").replace("%home%", homeName).replace("%player%", target.getName()));
            return false;
        }
        admin.teleport(loc);
        TextComponent message = new TextComponent("\u2713 ");
        message.setColor(ChatColor.GREEN);
        message.setBold(Boolean.valueOf(true));
        TextComponent text = new TextComponent(languageManager.getStringWithColor("HomeAdmin.TeleportHome-text") + " ");
        text.setColor(ChatColor.GREEN);
        text.setBold(Boolean.valueOf(false));
        TextComponent player = new TextComponent(target.getName() + " ");
        player.setColor(ChatColor.YELLOW);
        player.setBold(Boolean.valueOf(true));
        TextComponent home = new TextComponent(homeName);
        home.setColor(ChatColor.AQUA);
        home.setBold(Boolean.valueOf(true));
        message.addExtra((BaseComponent)text);
        message.addExtra((BaseComponent)player);
        message.addExtra((BaseComponent)home);
        admin.spigot().sendMessage((BaseComponent)message);
        return true;
    }

    private boolean addHome(Player admin, String targetName, String homeName, HomeManager homeManager) {
        Player target = Bukkit.getPlayerExact((String)targetName);
        if (target == null) {
            this.sendErrorMessage(admin, this.translate("Language.Player-is-not-online"));
            return false;
        }
        boolean added = homeManager.addHome(target, homeName);
        if (added) {
            HomePlugin.getCacheManager().addHome(target.getUniqueId(), homeName, admin.getLocation());
            TextComponent message = new TextComponent("\u2713 ");
            message.setColor(ChatColor.GREEN);
            message.setBold(Boolean.valueOf(true));
            TextComponent text = new TextComponent(languageManager.getStringWithColor("HomeAdmin.AddHome-text") + " ");
            text.setColor(ChatColor.GREEN);
            text.setBold(Boolean.valueOf(false));
            TextComponent home = new TextComponent(homeName);
            home.setColor(ChatColor.AQUA);
            home.setBold(Boolean.valueOf(true));
            TextComponent forText = new TextComponent(" " + languageManager.getString("AddHome-to-player") + " ");
            forText.setColor(ChatColor.GREEN);
            forText.setBold(Boolean.valueOf(false));
            TextComponent player = new TextComponent(target.getName());
            player.setColor(ChatColor.YELLOW);
            player.setBold(Boolean.valueOf(true));
            message.addExtra((BaseComponent)text);
            message.addExtra((BaseComponent)home);
            message.addExtra((BaseComponent)forText);
            message.addExtra((BaseComponent)player);
            admin.spigot().sendMessage((BaseComponent)message);
            return true;
        }
        this.sendErrorMessage(admin, languageManager.getStringWithColor("HomeAdmin.Home-Already-Exists-Admin").replace("%home%", homeName).replace("%player%", target.getName()));
        return false;
    }

    private void sendUsage(Player player) {
        player.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        player.sendMessage(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "         " + languageManager.getStringWithColor("HomeAdmin.Usage-title"));
        player.sendMessage("");
        this.sendUsageCommand(player, "/homeadmin list <player>", languageManager.getStringWithColor("HomeAdmin.List-usage-description"));
        this.sendUsageCommand(player, "/homeadmin tphome <player> <home>", languageManager.getStringWithColor("HomeAdmin.TpHome-usage-description"));
        this.sendUsageCommand(player, "/homeadmin addhome <player> <home>", languageManager.getStringWithColor("HomeAdmin.AddHome-usage-description"));
        this.sendUsageCommand(player, "/homeadmin deletehome <player> <home>", languageManager.getStringWithColor("HomeAdmin.DeleteHome-usage-description"));
        player.sendMessage("");
        player.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
    }

    private void sendUsageCommand(Player player, String command, String description) {
        TextComponent cmd = new TextComponent("  \u25b8 ");
        cmd.setColor(ChatColor.DARK_GRAY);
        TextComponent cmdText = new TextComponent(command);
        cmdText.setColor(ChatColor.YELLOW);
        cmdText.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command));
        cmdText.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(languageManager.getStringWithColor("HomeAdmin.HomeAdmin-click-suggest")).color(ChatColor.GRAY).create()));
        TextComponent desc = new TextComponent(" - " + description);
        desc.setColor(ChatColor.GRAY);
        cmd.addExtra((BaseComponent)cmdText);
        cmd.addExtra((BaseComponent)desc);
        player.spigot().sendMessage((BaseComponent)cmd);
    }

    private void sendErrorMessage(Player player, String message) {
        TextComponent error = new TextComponent("\u2717 ");
        error.setColor(ChatColor.RED);
        error.setBold(Boolean.valueOf(true));
        TextComponent text = new TextComponent(ChatColor.stripColor((String)message));
        text.setColor(ChatColor.RED);
        text.setBold(Boolean.valueOf(false));
        error.addExtra((BaseComponent)text);
        player.spigot().sendMessage((BaseComponent)error);
    }

    private void sendMsg(CommandSender sender, String path) {
        sender.sendMessage(this.translate(path));
    }

    private String translate(String path) {
        return HomePlugin.getLanguageManager().getStringWithColor(path);
    }
}

