/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.commands.home;

import fr.fuzeblocks.homeplugin.HomePlugin;
import fr.fuzeblocks.homeplugin.economy.EconomyManager;
import fr.fuzeblocks.homeplugin.gui.BackItem;
import fr.fuzeblocks.homeplugin.gui.ForwardItem;
import fr.fuzeblocks.homeplugin.gui.HomeItem;
import fr.fuzeblocks.homeplugin.home.HomeManager;
import fr.fuzeblocks.homeplugin.language.LanguageManager;
import fr.fuzeblocks.homeplugin.task.TeleportationManager;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.gui.PagedGui;
import xyz.xenondevs.invui.gui.structure.Markers;
import xyz.xenondevs.invui.item.Item;
import xyz.xenondevs.invui.item.ItemProvider;
import xyz.xenondevs.invui.item.builder.ItemBuilder;
import xyz.xenondevs.invui.item.impl.SimpleItem;
import xyz.xenondevs.invui.window.Window;

public class HomeCommand
implements CommandExecutor {
    private static final String HOME = "Home.";
    private static final String LANG = "Language.";

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        LanguageManager languageManager = HomePlugin.getLanguageManager();
        if (!(sender instanceof Player)) {
            sender.sendMessage(languageManager.getStringWithColor("Language.Only-a-player-can-execute"));
            return false;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("homeplugin.command.home")) {
            player.sendMessage(languageManager.getStringWithColor("Language.No-permission"));
            return false;
        }
        HomeManager homeManager = HomePlugin.getHomeManager();
        if (args.length == 1) {
            return this.teleportToHome(player, args[0], homeManager, languageManager);
        }
        if (args.length == 0) {
            return this.openHomeSelection(player, homeManager, languageManager);
        }
        player.sendMessage(languageManager.getStringWithColor("Home.Home-usage-message"));
        return false;
    }

    private boolean teleportToHome(Player player, String homeName, HomeManager homeManager, LanguageManager languageManager) {
        if (homeManager.isStatus(player)) {
            player.sendMessage(languageManager.getStringWithColor("Language.A-teleport-is-already-in-progress"));
            return false;
        }
        if (homeManager.getHomeNumber(player) <= 0) {
            player.sendMessage(languageManager.getStringWithColor("Home.Have-no-home"));
            return false;
        }
        Location homeLocation = homeManager.getHomeLocation(player, homeName);
        if (homeLocation == null) {
            player.sendMessage(languageManager.getStringWithColor("Home.Home-does-not-exist"));
            return false;
        }
        if (homeLocation.getWorld() == null) {
            player.sendMessage(languageManager.getStringWithColor("Home.Home-world-not-loaded"));
            return false;
        }
        double cost = EconomyManager.getHomeTeleportPrice();
        if (cost > 0.0 && !EconomyManager.pay(player, cost)) {
            player.sendMessage(languageManager.getStringWithColor("Language.Not-Enough-Money"));
            return false;
        }
        if (!this.isInCache(homeManager, player, homeName)) {
            homeManager.getCacheManager().addHome(player.getUniqueId(), homeName, homeLocation);
        }
        TeleportationManager.teleportPlayerToHome(player, homeName);
        return true;
    }

    private boolean openHomeSelection(Player player, HomeManager homeManager, LanguageManager languageManager) {
        if (homeManager.getHomeNumber(player) <= 0) {
            player.sendMessage(languageManager.getStringWithColor("Home.Have-no-home"));
            return false;
        }
        if (this.isGuiSupported()) {
            this.openHomeGui(player);
        } else {
            player.sendMessage(languageManager.getStringWithColor("Home.Gui-not-supported"));
        }
        return true;
    }

    private boolean isInCache(HomeManager homeManager, Player player, String homeName) {
        Map<String, Location> homes = homeManager.getCacheManager().getHomes(player.getUniqueId());
        return homes != null && homes.containsKey(homeName);
    }

    private void openHomeGui(Player player) {
        SimpleItem border = new SimpleItem((ItemProvider)new ItemBuilder(Material.BLACK_STAINED_GLASS_PANE).setDisplayName(""));
        List<Item> homeItems = this.getHomeItems(player);
        if (homeItems.isEmpty()) {
            player.sendMessage(HomePlugin.getLanguageManager().getStringWithColor("Home.Have-no-home"));
            return;
        }
        Object gui = ((PagedGui.Builder)((PagedGui.Builder)((PagedGui.Builder)((PagedGui.Builder)((PagedGui.Builder)PagedGui.items().setStructure("# # # # # # # # #", "# x x x x x x x #", "# x x x x x x x #", "# # # < # > # # #")).addIngredient('x', Markers.CONTENT_LIST_SLOT_HORIZONTAL)).addIngredient('#', border)).addIngredient('<', new BackItem())).addIngredient('>', new ForwardItem())).setContent(homeItems).build();
        Object window = ((Window.Builder.Normal.Single)((Window.Builder.Normal.Single)((Window.Builder.Normal.Single)Window.single().setViewer(player)).setTitle(HomePlugin.getLanguageManager().getStringWithColor("Home.Home-gui-title").replace("%player%", player.getName()))).setGui((Gui)gui)).build();
        window.open();
    }

    private List<Item> getHomeItems(Player player) {
        HomeManager homeManager = HomePlugin.getHomeManager();
        List<String> homeNames = homeManager.getHomesName(player);
        return homeNames.stream().filter(name -> name != null).map(HomeItem::new).collect(Collectors.toList());
    }

    private boolean isGuiSupported() {
        try {
            String raw = Bukkit.getBukkitVersion();
            String ver = raw.split("-")[0];
            int[] current = HomeCommand.parseVersionTriple(ver);
            int[] min = new int[]{1, 14, 0};
            int[] max = new int[]{1, 21, 10};
            return HomeCommand.compareVersion(current, min) >= 0 && HomeCommand.compareVersion(current, max) <= 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static int[] parseVersionTriple(String v) {
        if (v == null) {
            return new int[]{0, 0, 0};
        }
        v = v.replaceAll("[^0-9.]", "");
        String[] p = v.split("\\.");
        int major = 0;
        int minor = 0;
        int patch = 0;
        try {
            if (p.length > 0) {
                major = Integer.parseInt(p[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (p.length > 1) {
                minor = Integer.parseInt(p[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (p.length > 2) {
                patch = Integer.parseInt(p[2]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new int[]{major, minor, patch};
    }

    private static int compareVersion(int[] a, int[] b) {
        for (int i = 0; i < 3; ++i) {
            int cmp = Integer.compare(a[i], b[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }
}

