/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.commands.home;

import fr.fuzeblocks.homeplugin.HomePlugin;
import fr.fuzeblocks.homeplugin.home.HomeManager;
import fr.fuzeblocks.homeplugin.language.LanguageManager;
import fr.fuzeblocks.libs.net.kyori.adventure.text.Component;
import fr.fuzeblocks.libs.net.kyori.adventure.text.TextComponent;
import fr.fuzeblocks.libs.net.kyori.adventure.text.event.ClickEvent;
import fr.fuzeblocks.libs.net.kyori.adventure.text.event.HoverEvent;
import fr.fuzeblocks.libs.net.kyori.adventure.text.format.NamedTextColor;
import fr.fuzeblocks.libs.net.kyori.adventure.text.format.TextColor;
import fr.fuzeblocks.libs.net.kyori.adventure.text.format.TextDecoration;
import fr.fuzeblocks.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ListHomeCommand
implements CommandExecutor {
    private static final String HOME_LIST = "Home.List.";
    private static final String HOME = "Home.";
    private static final String LANG = "Language.";
    private static final LanguageManager languageManager = HomePlugin.getLanguageManager();

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(languageManager.getStringWithColor("Language.Only-a-player-can-execute"));
            return false;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("homeplugin.command.listhome")) {
            player.sendMessage(languageManager.getStringWithColor("Language.No-permission"));
            return false;
        }
        HomeManager homeManager = HomePlugin.getHomeManager();
        List<String> homeNames = homeManager.getHomesName(player);
        if (homeNames == null || homeNames.isEmpty()) {
            player.sendMessage(languageManager.getStringWithColor("Home.Have-no-home"));
            return false;
        }
        int homeCount = homeNames.size();
        this.sendHeader(player, homeCount);
        for (String name : homeNames) {
            Location loc;
            if (name == null || (loc = homeManager.getHomeLocation(player, name)) == null || loc.getWorld() == null) continue;
            this.sendHomeEntry(player, name, loc);
        }
        this.sendFooter(player);
        return true;
    }

    private void sendHeader(Player player, int homeCount) {
        Object header = ((TextComponent.Builder)Component.text().append((Component)Component.text("\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac", (TextColor)NamedTextColor.DARK_GRAY))).build();
        String titleText = this.translate("Home.List.List-header-title");
        Object title = ((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text("         "))).append(this.deserialize(titleText))).build();
        String countText = this.translate("Home.List.List-total-label").replace("{count}", String.valueOf(homeCount));
        Object count = ((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text("              "))).append(this.deserialize(countText))).build();
        HomePlugin.getAdventure().player(player).sendMessage((Component)header);
        HomePlugin.getAdventure().player(player).sendMessage((Component)title);
        HomePlugin.getAdventure().player(player).sendMessage((Component)count);
        HomePlugin.getAdventure().player(player).sendMessage(Component.empty());
    }

    private void sendHomeEntry(Player player, String homeName, Location location) {
        String homeIcon = ChatColor.stripColor((String)this.translate("Home.List.List-home-icon"));
        Object homeNameLine = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text("  "))).append(this.deserialize(this.translate("Home.List.List-home-icon")))).append((Component)Component.text(" "))).append(Component.text(homeName, (TextColor)NamedTextColor.AQUA).decorate(TextDecoration.BOLD))).build();
        Object locationLine = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text("     "))).append(this.deserialize(this.translate("Home.List.List-location-icon")))).append((Component)Component.text(" "))).append((Component)Component.text(String.format("%d, %d, %d", location.getBlockX(), location.getBlockY(), location.getBlockZ()), (TextColor)NamedTextColor.GREEN))).append((Component)Component.text(" "))).append(this.deserialize(this.translate("Home.List.List-world-label").replace("{world}", location.getWorld().getName())))).build();
        Component buttons = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text("     ").append(this.createTeleportButton(homeName))).append(Component.text("  "))).append(this.createRelocateButton(homeName))).append(Component.text("  "))).append(this.createDeleteButton(homeName));
        HomePlugin.getAdventure().player(player).sendMessage((Component)homeNameLine);
        HomePlugin.getAdventure().player(player).sendMessage((Component)locationLine);
        HomePlugin.getAdventure().player(player).sendMessage(buttons);
        HomePlugin.getAdventure().player(player).sendMessage(Component.empty());
    }

    private Component createTeleportButton(String homeName) {
        String buttonText = this.translate("Home.List.List-teleport-button");
        String hoverText = this.translate("Home.List.List-teleport-hover").replace("{home}", homeName);
        return this.deserialize(buttonText).hoverEvent(HoverEvent.showText(this.deserialize(hoverText))).clickEvent(ClickEvent.runCommand("/home " + homeName));
    }

    private Component createRelocateButton(String homeName) {
        String buttonText = this.translate("Home.List.List-relocate-button");
        String hoverText = this.translate("Home.List.List-relocate-hover").replace("{home}", homeName);
        return this.deserialize(buttonText).hoverEvent(HoverEvent.showText(this.deserialize(hoverText))).clickEvent(ClickEvent.runCommand("/relocatehome " + homeName));
    }

    private Component createDeleteButton(String homeName) {
        String buttonText = this.translate("Home.List.List-delete-button");
        String hoverText = this.translate("Home.List.List-delete-hover").replace("{home}", homeName);
        return this.deserialize(buttonText).hoverEvent(HoverEvent.showText(this.deserialize(hoverText))).clickEvent(ClickEvent.suggestCommand("/delhome " + homeName));
    }

    private void sendFooter(Player player) {
        TextComponent footer = Component.text("\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac", (TextColor)NamedTextColor.DARK_GRAY);
        HomePlugin.getAdventure().player(player).sendMessage(footer);
    }

    private String translate(String path) {
        return languageManager.getStringWithColor(path);
    }

    private Component deserialize(String text) {
        String converted = ChatColor.translateAlternateColorCodes((char)'&', (String)text);
        return LegacyComponentSerializer.legacySection().deserialize(converted);
    }
}

