/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.commands.home;

import fr.fuzeblocks.homeplugin.HomePlugin;
import fr.fuzeblocks.homeplugin.home.HomeManager;
import fr.fuzeblocks.homeplugin.language.LanguageManager;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class RenameHomeCommand
implements CommandExecutor {
    private static final String HOME = "Home.";
    private static final String LANG = "Language.";

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        LanguageManager languageManager = HomePlugin.getLanguageManager();
        if (!(sender instanceof Player)) {
            sender.sendMessage(languageManager.getStringWithColor("Language.Only-a-player-can-execute"));
            return false;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("homeplugin.command.renamehome")) {
            player.sendMessage(languageManager.getStringWithColor("Language.No-permission"));
            return false;
        }
        if (args.length != 2) {
            this.sendUsage(player);
            return false;
        }
        return this.renameHome(player, args[0], args[1], languageManager);
    }

    private boolean renameHome(Player player, String oldHomeName, String newHomeName, LanguageManager languageManager) {
        HomeManager homeManager = HomePlugin.getHomeManager();
        if (!homeManager.exist(player, oldHomeName)) {
            player.sendMessage(languageManager.getStringWithColor("Home.Home-does-not-exist"));
            return false;
        }
        if (homeManager.exist(player, newHomeName)) {
            player.sendMessage(languageManager.getStringWithColor("Home.Home-already-exists").replace("{home}", newHomeName).replace("%home%", newHomeName));
            return false;
        }
        Location homeLocation = homeManager.getHomeLocation(player, oldHomeName);
        if (homeLocation == null) {
            player.sendMessage(languageManager.getStringWithColor("Language.Error"));
            return false;
        }
        boolean success = homeManager.renameHome(player, oldHomeName, newHomeName);
        if (success) {
            HomePlugin.getCacheManager().removeHome(player.getUniqueId(), oldHomeName);
            HomePlugin.getCacheManager().addHome(player.getUniqueId(), newHomeName, homeLocation);
            player.sendMessage(languageManager.getStringWithColor("Home.Home-renamed").replace("{old_home}", oldHomeName).replace("%old_home%", oldHomeName).replace("{new_home}", newHomeName).replace("%new_home%", newHomeName));
        } else {
            player.sendMessage(languageManager.getStringWithColor("Language.Error"));
        }
        return success;
    }

    private void sendUsage(Player player) {
        player.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        String title = this.translate("Home.Rename-management-title");
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("         " + title)));
        player.sendMessage("");
        String usageIcon = ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)this.translate("Home.Rename-usage-icon")));
        TextComponent viewCmd = new TextComponent("  " + usageIcon + " ");
        viewCmd.setColor(ChatColor.DARK_GRAY);
        TextComponent viewText = new TextComponent("/renamehome <old_name> <new_name>");
        viewText.setColor(ChatColor.YELLOW);
        viewText.setBold(Boolean.valueOf(false));
        viewText.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/renamehome <old_name> <new_name>"));
        String viewHover = this.translate("Home.Rename-click-suggest");
        viewText.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(ChatColor.stripColor((String)viewHover)).color(ChatColor.GRAY).create()));
        String viewDesc = this.translate("Home.Rename-view-description");
        TextComponent viewDescComp = new TextComponent(" - " + ChatColor.stripColor((String)viewDesc));
        viewDescComp.setColor(ChatColor.GRAY);
        viewCmd.addExtra((BaseComponent)viewText);
        viewCmd.addExtra((BaseComponent)viewDescComp);
        player.spigot().sendMessage((BaseComponent)viewCmd);
        player.sendMessage("");
        player.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
    }

    private String translate(String path) {
        return HomePlugin.getLanguageManager().getStringWithColor(path);
    }
}

