/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.commands.home;

import fr.fuzeblocks.homeplugin.HomePlugin;
import fr.fuzeblocks.homeplugin.economy.EconomyManager;
import fr.fuzeblocks.homeplugin.event.OnHomeCreatedEvent;
import fr.fuzeblocks.homeplugin.home.HomeManager;
import fr.fuzeblocks.homeplugin.home.HomePermissionManager;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class SetHomeCommand
implements CommandExecutor {
    private static final String HOME = "Home.";
    private static final String LANG = "Language.";
    private static final String PERMISSION_SET_HOME = "homeplugin.command.sethome";

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(SetHomeCommand.translate("Language.Only-a-player-can-execute"));
            return false;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION_SET_HOME)) {
            player.sendMessage(SetHomeCommand.translate("Home.SetHome-permission-deny-message"));
            return false;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("info")) {
            HomeManager homeManager = HomePlugin.getHomeManager();
            int used = homeManager.getHomeNumber(player);
            int max = HomePermissionManager.getMaxHomes(player);
            int remaining = Math.max(0, max - used);
            player.sendMessage(SetHomeCommand.translate("Home.Home-info-count").replace("%used%", String.valueOf(used)).replace("%max%", String.valueOf(max)).replace("%remaining%", String.valueOf(remaining)));
            return true;
        }
        if (args.length == 1) {
            String homeName = args[0];
            return this.createHome(player, homeName);
        }
        this.sendUsage(player);
        return false;
    }

    private void sendUsage(Player player) {
        player.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        String title = SetHomeCommand.translate("Home.SetHome-management-title");
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("         " + title)));
        player.sendMessage("");
        String usageIcon = ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)SetHomeCommand.translate("Home.SetHome-usage-icon")));
        TextComponent viewCmd = new TextComponent("  " + usageIcon + " ");
        viewCmd.setColor(ChatColor.DARK_GRAY);
        TextComponent viewText = new TextComponent("/sethome <home-name>");
        viewText.setColor(ChatColor.YELLOW);
        viewText.setBold(Boolean.valueOf(false));
        viewText.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/sethome <home-name>"));
        String viewHover = SetHomeCommand.translate("Home.SetHome-click-suggest");
        viewText.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(ChatColor.stripColor((String)viewHover)).color(ChatColor.GRAY).create()));
        String viewDesc = SetHomeCommand.translate("Home.SetHome-view-description");
        TextComponent viewDescComp = new TextComponent(" - " + ChatColor.stripColor((String)viewDesc));
        viewDescComp.setColor(ChatColor.GRAY);
        viewCmd.addExtra((BaseComponent)viewText);
        viewCmd.addExtra((BaseComponent)viewDescComp);
        player.spigot().sendMessage((BaseComponent)viewCmd);
        player.sendMessage("");
        player.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
    }

    private boolean createHome(Player player, String homeName) {
        HomeManager homeManager = HomePlugin.getHomeManager();
        if (homeManager.isStatus(player)) {
            player.sendMessage(SetHomeCommand.translate("Language.A-teleport-is-already-in-progress"));
            return false;
        }
        if (!this.canSetHome(player)) {
            return false;
        }
        if (homeManager.exist(player, homeName)) {
            player.sendMessage(SetHomeCommand.translate("Home.Home-Already-Exists"));
            return false;
        }
        if (HomePlugin.getConfigurationSection().getBoolean("Config.Home.Prevent-Unfair-Location", true) && !SetHomeCommand.isFair(player)) {
            return false;
        }
        Location loc = player.getLocation();
        OnHomeCreatedEvent event = new OnHomeCreatedEvent(player, loc, homeName);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        double cost = EconomyManager.getHomeCreationCost();
        if (cost > 0.0 && !EconomyManager.pay(player, cost)) {
            player.sendMessage(SetHomeCommand.translate("Language.Not-Enough-Money"));
            return false;
        }
        boolean success = homeManager.addHome(player, event.getHomeName());
        if (success) {
            player.sendMessage(SetHomeCommand.translate("Home.Home-added"));
        } else {
            player.sendMessage(SetHomeCommand.translate("Language.Error"));
        }
        return success;
    }

    private boolean canSetHome(Player player) {
        String bypassPerm = HomePlugin.getLanguageManager().getString("Home.Home-limite-permission-for-bypass");
        if (bypassPerm != null && player.hasPermission(bypassPerm)) {
            return true;
        }
        boolean allowed = HomePermissionManager.canSetHome(player);
        if (!allowed) {
            player.sendMessage(SetHomeCommand.translate("Home.Home-limite-message"));
        }
        return allowed;
    }

    public static boolean isFair(Player player) {
        List disabledWorlds;
        Location loc = player.getLocation();
        World world = loc.getWorld();
        if (world == null) {
            player.sendMessage(SetHomeCommand.translate("Home.Invalid-world"));
            return false;
        }
        if (loc.getY() >= (double)(world.getMaxHeight() - 2) || loc.getY() <= (double)(SetHomeCommand.getWorldMinY(world) + 5)) {
            player.sendMessage(SetHomeCommand.translate("Home.Invalid-height"));
            return false;
        }
        Material mat = loc.getBlock().getType();
        if (mat == Material.NETHER_PORTAL || mat == Material.END_PORTAL || mat == Material.END_GATEWAY) {
            player.sendMessage(SetHomeCommand.translate("Home.Portal-location"));
            return false;
        }
        if (mat == Material.WATER || mat == Material.BUBBLE_COLUMN || mat == Material.LAVA) {
            player.sendMessage(SetHomeCommand.translate("Home.Water-location"));
            return false;
        }
        List list = disabledWorlds = HomePlugin.getConfigurationSection() == null ? List.of() : HomePlugin.getConfigurationSection().getStringList("Config.Home.Disabled-Worlds");
        if (!disabledWorlds.isEmpty() && disabledWorlds.stream().map(String::toLowerCase).anyMatch(name -> name.equals(world.getName().toLowerCase()))) {
            player.sendMessage(SetHomeCommand.translate("Home.Disabled-world"));
            return false;
        }
        Block ground = world.getBlockAt(loc.getBlockX(), loc.getBlockY() - 1, loc.getBlockZ());
        if (!ground.getType().isSolid()) {
            player.sendMessage(SetHomeCommand.translate("Home.No-solid-ground"));
            return false;
        }
        if (SetHomeCommand.isOnFloatingPlatform(loc)) {
            player.sendMessage(SetHomeCommand.translate("Home.Floating-platform"));
            return false;
        }
        return true;
    }

    public static boolean isOnFloatingPlatform(Location loc) {
        int z;
        int y;
        World world = loc.getWorld();
        if (world == null) {
            return false;
        }
        int x = loc.getBlockX();
        Block ground = world.getBlockAt(x, (y = loc.getBlockY()) - 1, z = loc.getBlockZ());
        if (!ground.getType().isSolid()) {
            return false;
        }
        int requiredAirDepth = Math.max(1, HomePlugin.getConfigurationSection().getInt("Config.Home.FloatingCheck.AirDepth", 5));
        int horizontalRadius = Math.max(1, HomePlugin.getConfigurationSection().getInt("Config.Home.FloatingCheck.HorizontalRadius", 1));
        int minY = SetHomeCommand.getWorldMinY(world);
        for (int i = 1; i <= requiredAirDepth; ++i) {
            int checkY = ground.getY() - i;
            if (checkY < minY) {
                return false;
            }
            Material t = world.getBlockAt(x, checkY, z).getType();
            if (SetHomeCommand.isAir(t)) continue;
            return false;
        }
        if (SetHomeCommand.hasNearbySolidBlocks(world, ground.getX(), ground.getY(), ground.getZ(), horizontalRadius)) {
            return false;
        }
        return !SetHomeCommand.hasNearbySolidBlocks(world, ground.getX(), ground.getY() - 1, ground.getZ(), horizontalRadius);
    }

    private static boolean isAir(Material t) {
        return t == Material.AIR || t == Material.CAVE_AIR || t == Material.VOID_AIR;
    }

    private static int getWorldMinY(World world) {
        try {
            return world.getMinHeight();
        }
        catch (NoSuchMethodError e) {
            return 0;
        }
    }

    private static boolean hasNearbySolidBlocks(World world, int x, int y, int z, int radius) {
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                Material type;
                if (dx == 0 && dz == 0 || !(type = world.getBlockAt(x + dx, y, z + dz).getType()).isSolid()) continue;
                return true;
            }
        }
        return false;
    }

    private static String translate(String key) {
        return HomePlugin.getLanguageManager().getStringWithColor(key);
    }
}

