/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.event;

import fr.fuzeblocks.homeplugin.sync.SyncMethod;
import fr.fuzeblocks.homeplugin.tpa.TpaRequest;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class OnEventAction
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final Player player;
    private final Location from;
    private final Location to;
    private final SyncMethod type;
    private String homeName;
    private boolean isCancelled = false;

    public OnEventAction(Player player, Location from, Location to, SyncMethod type) {
        this.player = player;
        this.from = from != null ? from.clone() : null;
        this.to = to != null ? to.clone() : null;
        this.type = type;
    }

    public OnEventAction(Player player, Location from, Location to, SyncMethod type, String homeName) {
        this.player = player;
        this.from = from != null ? from.clone() : null;
        this.to = to != null ? to.clone() : null;
        this.type = type;
        this.homeName = homeName;
    }

    public OnEventAction(Player player, Location from, Location to) {
        this.player = player;
        this.from = from != null ? from.clone() : null;
        this.to = to != null ? to.clone() : null;
        this.type = null;
    }

    public OnEventAction(Player player, Location from, Location to, String homeName) {
        this.player = player;
        this.from = from != null ? from.clone() : null;
        this.to = to != null ? to.clone() : null;
        this.type = null;
        this.homeName = homeName;
    }

    public OnEventAction(Player player, Location location, SyncMethod type) {
        this.player = player;
        this.from = player != null ? player.getLocation().clone() : null;
        this.to = location != null ? location.clone() : null;
        this.type = type;
    }

    public OnEventAction(Player player, Location location) {
        this.player = player;
        this.from = player != null ? player.getLocation().clone() : null;
        this.to = location != null ? location.clone() : null;
        this.type = null;
    }

    public OnEventAction(Player player, Location location, SyncMethod type, String homeName) {
        this.player = player;
        this.from = player != null ? player.getLocation().clone() : null;
        this.to = location != null ? location.clone() : null;
        this.type = type;
        this.homeName = homeName;
    }

    public OnEventAction(Player player, Location location, String homeName) {
        this.player = player;
        this.from = player != null ? player.getLocation().clone() : null;
        this.to = location != null ? location.clone() : null;
        this.type = null;
        this.homeName = homeName;
    }

    public OnEventAction(TpaRequest tpaRequest) {
        this.player = tpaRequest.sender;
        this.from = tpaRequest.sender != null ? tpaRequest.sender.getLocation().clone() : null;
        this.to = tpaRequest.target != null && tpaRequest.target.getLocation() != null ? tpaRequest.target.getLocation().clone() : null;
        this.type = null;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Location getFrom() {
        return this.from != null ? this.from.clone() : null;
    }

    public Location getTo() {
        return this.to != null ? this.to.clone() : null;
    }

    @Deprecated
    public Location getLocation() {
        return this.getTo();
    }

    public SyncMethod getType() {
        return this.type;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean b) {
        this.isCancelled = b;
    }

    public String getHomeName() {
        return this.homeName;
    }

    public void setHomeName(String homeName) {
        this.homeName = homeName;
    }
}

