/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.home;

import fr.fuzeblocks.homeplugin.HomePlugin;
import fr.fuzeblocks.homeplugin.cache.CacheManager;
import fr.fuzeblocks.homeplugin.home.Home;
import fr.fuzeblocks.homeplugin.home.sql.HomeSQLManager;
import fr.fuzeblocks.homeplugin.home.yml.HomeYMLManager;
import fr.fuzeblocks.homeplugin.status.StatusManager;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class HomeManager
implements Home {
    private static HomeManager instance = null;
    private final HomeYMLManager homeYMLManager = HomePlugin.getHomeYMLManager();
    private final HomeSQLManager homeSQLManager = HomePlugin.getHomeSQLManager();

    private HomeManager() {
    }

    public static HomeManager getInstance() {
        if (instance == null) {
            instance = new HomeManager();
        }
        return instance;
    }

    @Override
    public boolean addHome(Player player, String name) {
        if (this.isYAML()) {
            return this.homeYMLManager.addHome(player, name);
        }
        return this.homeSQLManager.addHome(player, name);
    }

    @Override
    public boolean setHome(Player player, String name, Location location) {
        if (this.isYAML()) {
            return this.homeYMLManager.setHome(player, name, location);
        }
        return this.homeSQLManager.setHome(player, name, location);
    }

    @Override
    public boolean renameHome(Player player, String oldHomeName, String newHomeName) {
        if (this.isYAML()) {
            return this.homeYMLManager.renameHome(player, oldHomeName, newHomeName);
        }
        return this.homeSQLManager.renameHome(player, oldHomeName, newHomeName);
    }

    @Override
    public boolean relocateHome(Player player, String homeName, Location newLocation) {
        if (this.isYAML()) {
            return this.homeYMLManager.relocateHome(player, homeName, newLocation);
        }
        return this.homeSQLManager.relocateHome(player, homeName, newLocation);
    }

    @Override
    public List<Location> getHomesLocation(Player player) {
        if (this.isYAML()) {
            return this.homeYMLManager.getHomesLocation(player);
        }
        return this.homeSQLManager.getHomesLocation(player);
    }

    @Override
    public int getHomeNumber(Player player) {
        if (this.isYAML()) {
            return this.homeYMLManager.getHomeNumber(player);
        }
        return this.homeSQLManager.getHomeNumber(player);
    }

    @Override
    public List<String> getHomesName(Player player) {
        if (this.isYAML()) {
            return this.homeYMLManager.getHomesName(player);
        }
        return this.homeSQLManager.getHomesName(player);
    }

    @Override
    public CacheManager getCacheManager() {
        return HomePlugin.getCacheManager();
    }

    @Override
    public Location getHomeLocation(Player player, String homeName) {
        if (this.isYAML()) {
            return this.homeYMLManager.getHomeLocation(player, homeName);
        }
        return this.homeSQLManager.getHomeLocation(player, homeName);
    }

    @Override
    public boolean deleteHome(Player player, String homeName) {
        if (this.isYAML()) {
            return this.homeYMLManager.deleteHome(player, homeName);
        }
        return this.homeSQLManager.deleteHome(player, homeName);
    }

    @Override
    public boolean isStatus(Player player) {
        return StatusManager.getPlayerStatus(player);
    }

    @Override
    public boolean exist(Player player, String homeName) {
        if (this.isYAML()) {
            return this.homeYMLManager.exist(player, homeName);
        }
        return this.homeSQLManager.exist(player, homeName);
    }
}

