/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.home;

import fr.fuzeblocks.homeplugin.home.HomeRequestStore;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import redis.clients.jedis.JedisPooled;

public class RedisHomeStore
implements HomeRequestStore {
    private final JedisPooled jedis;
    private final Logger logger;
    private static final String KEY_PREFIX = "homes:";

    public RedisHomeStore(JedisPooled jedis) {
        this.jedis = jedis;
        this.logger = Logger.getLogger(RedisHomeStore.class.getName());
    }

    @Override
    public void addHome(UUID playerId, String homeName, Location location) {
        if (playerId == null || homeName == null || location == null) {
            this.logger.warning("Cannot add home: null parameter provided");
            return;
        }
        String key = this.getKey(playerId);
        String serialized = this.serializeLocation(location);
        if (serialized != null) {
            this.jedis.hset(key, homeName, serialized);
        }
    }

    @Override
    public void removeHome(UUID playerId, String homeName) {
        if (playerId == null || homeName == null) {
            this.logger.warning("Cannot remove home: null parameter provided");
            return;
        }
        this.jedis.hdel(this.getKey(playerId), homeName);
    }

    @Override
    public void relocateHome(UUID playerId, String homeName, Location newLocation) {
        if (playerId == null || homeName == null || newLocation == null) {
            this.logger.warning("Cannot relocate home: null parameter provided");
            return;
        }
        String key = this.getKey(playerId);
        if (!this.jedis.hexists(key, homeName)) {
            this.logger.warning("Cannot relocate home '" + homeName + "' for player " + String.valueOf(playerId) + ": home does not exist");
            return;
        }
        String serialized = this.serializeLocation(newLocation);
        if (serialized != null) {
            this.jedis.hset(key, homeName, serialized);
        }
    }

    @Override
    public Map<String, Location> getHomes(UUID playerId) {
        if (playerId == null) {
            this.logger.warning("Cannot get homes: playerId is null");
            return new HashMap<String, Location>();
        }
        Map<String, String> data = this.jedis.hgetAll(this.getKey(playerId));
        if (data == null || data.isEmpty()) {
            return new HashMap<String, Location>();
        }
        return this.deserializeLocationMap(data);
    }

    @Override
    public void clearHomes(UUID playerId) {
        if (playerId == null) {
            this.logger.warning("Cannot clear homes: playerId is null");
            return;
        }
        this.jedis.del(this.getKey(playerId));
    }

    @Override
    public void clearAllHomes() {
        try {
            Set<String> keys = this.jedis.keys("homes:*");
            if (keys != null && !keys.isEmpty()) {
                String[] keyArray = keys.toArray(new String[0]);
                this.jedis.del(keyArray);
            }
        }
        catch (Exception e) {
            this.logger.severe("Error clearing all homes: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private String getKey(UUID playerId) {
        return KEY_PREFIX + playerId.toString();
    }

    private String serializeLocation(Location location) {
        if (location == null) {
            return null;
        }
        if (location.getWorld() == null) {
            this.logger.warning("Cannot serialize location: world is null");
            return null;
        }
        try {
            YamlConfiguration yaml = new YamlConfiguration();
            yaml.set("location", (Object)location);
            return yaml.saveToString();
        }
        catch (Exception e) {
            this.logger.severe("Error serializing location: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private Location deserializeLocation(String data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        try {
            YamlConfiguration yaml = new YamlConfiguration();
            yaml.loadFromString(data);
            Object obj = yaml.get("location");
            if (obj instanceof Location) {
                return (Location)obj;
            }
            this.logger.warning("Deserialized object is not a Location");
            return null;
        }
        catch (InvalidConfigurationException e) {
            this.logger.severe("Invalid YAML configuration while deserializing location: " + e.getMessage());
            return null;
        }
        catch (Exception e) {
            this.logger.severe("Error deserializing location: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private Map<String, Location> deserializeLocationMap(Map<String, String> data) {
        HashMap<String, Location> map = new HashMap<String, Location>();
        if (data == null) {
            return map;
        }
        data.forEach((key, value) -> {
            Location location = this.deserializeLocation((String)value);
            if (location != null) {
                map.put((String)key, location);
            } else {
                this.logger.warning("Failed to deserialize location for home: " + key);
            }
        });
        return map;
    }
}

