/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.home.yml;

import fr.fuzeblocks.homeplugin.HomePlugin;
import fr.fuzeblocks.homeplugin.cache.CacheManager;
import fr.fuzeblocks.homeplugin.home.Home;
import fr.fuzeblocks.homeplugin.status.StatusManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class HomeYMLManager
implements Home {
    private final File file;
    private final YamlConfiguration yaml;

    public HomeYMLManager(File file) {
        this.file = file;
        this.yaml = YamlConfiguration.loadConfiguration((File)file);
    }

    @Override
    public boolean addHome(@NotNull Player player, String name) {
        String key = String.valueOf(player.getUniqueId()) + ".Home";
        if (!this.yaml.contains(key + "." + name)) {
            Location location = player.getLocation();
            this.yaml.set(key + "." + name + ".X", (Object)location.getX());
            this.yaml.set(key + "." + name + ".Y", (Object)location.getY());
            this.yaml.set(key + "." + name + ".Z", (Object)location.getZ());
            this.yaml.set(key + "." + name + ".PITCH", (Object)Float.valueOf(location.getPitch()));
            this.yaml.set(key + "." + name + ".YAW", (Object)Float.valueOf(location.getYaw()));
            this.yaml.set(key + "." + name + ".World", (Object)location.getWorld().getName());
            try {
                this.yaml.save(this.file);
                return true;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    @Override
    public boolean setHome(@NotNull Player player, String name, Location location) {
        String key = String.valueOf(player.getUniqueId()) + ".Home";
        if (!this.yaml.contains(key + "." + name)) {
            this.yaml.set(key + "." + name + ".X", (Object)location.getX());
            this.yaml.set(key + "." + name + ".Y", (Object)location.getY());
            this.yaml.set(key + "." + name + ".Z", (Object)location.getZ());
            this.yaml.set(key + "." + name + ".PITCH", (Object)Float.valueOf(location.getPitch()));
            this.yaml.set(key + "." + name + ".YAW", (Object)Float.valueOf(location.getYaw()));
            this.yaml.set(key + "." + name + ".World", (Object)location.getWorld().getName());
            try {
                this.yaml.save(this.file);
                return true;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    @Override
    public boolean renameHome(@NotNull Player player, String oldHomeName, String newHomeName) {
        String oldKey = String.valueOf(player.getUniqueId()) + ".Home." + oldHomeName;
        String newKey = String.valueOf(player.getUniqueId()) + ".Home." + newHomeName;
        if (this.yaml.contains(oldKey) && !this.yaml.contains(newKey)) {
            this.yaml.set(newKey + ".X", (Object)this.yaml.getDouble(oldKey + ".X"));
            this.yaml.set(newKey + ".Y", (Object)this.yaml.getDouble(oldKey + ".Y"));
            this.yaml.set(newKey + ".Z", (Object)this.yaml.getDouble(oldKey + ".Z"));
            this.yaml.set(newKey + ".PITCH", (Object)this.yaml.getDouble(oldKey + ".PITCH"));
            this.yaml.set(newKey + ".YAW", (Object)this.yaml.getDouble(oldKey + ".YAW"));
            this.yaml.set(newKey + ".World", (Object)this.yaml.getString(oldKey + ".World"));
            this.yaml.set(oldKey, null);
            try {
                this.yaml.save(this.file);
                return true;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    @Override
    public boolean relocateHome(Player player, String homeName, Location newLocation) {
        String key = String.valueOf(player.getUniqueId()) + ".Home." + homeName + ".";
        if (this.yaml.contains(key)) {
            this.yaml.set(key + "X", (Object)newLocation.getX());
            this.yaml.set(key + "Y", (Object)newLocation.getY());
            this.yaml.set(key + "Z", (Object)newLocation.getZ());
            this.yaml.set(key + "PITCH", (Object)Float.valueOf(newLocation.getPitch()));
            this.yaml.set(key + "YAW", (Object)Float.valueOf(newLocation.getYaw()));
            this.yaml.set(key + "World", (Object)newLocation.getWorld().getName());
            try {
                this.yaml.save(this.file);
                return true;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    @Override
    public List<Location> getHomesLocation(Player player) {
        ArrayList<Location> homes = new ArrayList<Location>();
        if (this.getHomeNumber(player) > 0) {
            String key = String.valueOf(player.getUniqueId()) + ".Home.";
            Set homeNames = this.yaml.getConfigurationSection(key).getKeys(false);
            for (String homeName : homeNames) {
                Location homeLocation = this.getHomeLocation(player, homeName);
                if (homeLocation == null) continue;
                homes.add(homeLocation);
            }
        }
        return homes;
    }

    @Override
    public int getHomeNumber(@NotNull Player player) {
        String key = String.valueOf(player.getUniqueId()) + ".Home.";
        try {
            ConfigurationSection configurationSection = this.yaml.getConfigurationSection(key);
            if (configurationSection == null) {
                return 0;
            }
            Set home = configurationSection.getKeys(false);
            return home.size();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public List<String> getHomesName(@NotNull Player player) {
        ArrayList<String> home_names = new ArrayList<String>();
        ConfigurationSection homesSection = this.yaml.getConfigurationSection(String.valueOf(player.getUniqueId()) + ".Home");
        if (homesSection != null) {
            Set homeNames = homesSection.getKeys(false);
            home_names.addAll(homeNames);
        }
        return home_names;
    }

    @Override
    public CacheManager getCacheManager() {
        return HomePlugin.getCacheManager();
    }

    @Override
    public Location getHomeLocation(@NotNull Player player, String homeName) {
        String key = String.valueOf(player.getUniqueId()) + ".Home." + homeName + ".";
        assert (homeName != null);
        if (this.yaml.contains(key)) {
            return new Location(Bukkit.getWorld((String)this.yaml.getString(key + "World")), this.yaml.getDouble(key + "X"), this.yaml.getDouble(key + "Y"), this.yaml.getDouble(key + "Z"), (float)this.yaml.getDouble(key + "YAW"), (float)this.yaml.getDouble(key + "PITCH"));
        }
        return null;
    }

    @Override
    public boolean deleteHome(@NotNull Player player, String homeName) {
        String key = String.valueOf(player.getUniqueId()) + ".Home." + homeName;
        if (this.yaml.contains(key)) {
            this.yaml.set(key, null);
            try {
                this.yaml.save(this.file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isStatus(Player player) {
        return StatusManager.getPlayerStatus(player);
    }

    @Override
    public boolean exist(@NotNull Player player, String homeName) {
        String key = String.valueOf(player.getUniqueId()) + ".Home." + homeName;
        return this.yaml.contains(key);
    }
}

