/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.language;

import fr.fuzeblocks.homeplugin.HomePlugin;
import fr.fuzeblocks.homeplugin.language.Language;
import java.io.File;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageManager {
    private final Language language;
    private final File file;
    private final HomePlugin plugin;
    private YamlConfiguration yamlConfiguration;

    public LanguageManager(Language type, HomePlugin plugin) {
        this.language = type;
        this.plugin = plugin;
        String fileName = type.toString().toLowerCase() + ".yml";
        this.file = new File(plugin.getDataFolder(), fileName);
        if (!this.file.exists()) {
            plugin.saveResource(fileName, false);
        }
        this.yamlConfiguration = YamlConfiguration.loadConfiguration((File)this.file);
    }

    @NotNull
    public String getString(String key) {
        String value = this.yamlConfiguration.getString(key);
        return value != null ? value : "";
    }

    @NotNull
    public String getString(String key, String defaultValue) {
        return this.yamlConfiguration.getString(key, defaultValue);
    }

    @NotNull
    public String getStringWithColor(String key) {
        return LanguageManager.translateAlternateColorCodes(this.yamlConfiguration.getString(key));
    }

    @NotNull
    public String getStringWithColor(String key, String defaultValue) {
        return LanguageManager.translateAlternateColorCodes(this.yamlConfiguration.getString(key, defaultValue));
    }

    @NotNull
    public static String translateAlternateColorCodes(@Nullable String s) {
        if (s == null) {
            return "\u00a7c[Traduction manquante]";
        }
        return s.replace('&', '\u00a7');
    }

    public boolean regenerate() {
        try {
            if (this.file.exists() && !this.file.delete()) {
                return false;
            }
            this.plugin.saveResource(this.file.getName(), true);
            this.yamlConfiguration = YamlConfiguration.loadConfiguration((File)this.file);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Language getLanguage() {
        return this.language;
    }
}

