/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.language;

import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.YamlConfiguration;

public class LanguageMerge {
    private final YamlConfiguration editedConfig;
    private final YamlConfiguration latestConfig;
    private final YamlConfiguration mergedConfig;
    private final File mergedFile;

    public LanguageMerge(File editedFile, File latestFile) {
        this.editedConfig = YamlConfiguration.loadConfiguration((File)editedFile);
        this.latestConfig = YamlConfiguration.loadConfiguration((File)latestFile);
        this.mergedConfig = new YamlConfiguration();
        this.mergedFile = editedFile;
    }

    public void mergeAddOnly() {
        for (String key : this.editedConfig.getKeys(true)) {
            this.mergedConfig.set(key, this.editedConfig.get(key));
        }
        for (String key : this.latestConfig.getKeys(true)) {
            if (this.mergedConfig.contains(key)) continue;
            this.mergedConfig.set(key, this.latestConfig.get(key));
        }
    }

    public void mergeSync() {
        for (String key : this.editedConfig.getKeys(true)) {
            this.mergedConfig.set(key, this.editedConfig.get(key));
        }
        for (String key : this.mergedConfig.getKeys(true)) {
            if (this.latestConfig.contains(key)) continue;
            this.mergedConfig.set(key, null);
        }
        for (String key : this.latestConfig.getKeys(true)) {
            if (this.mergedConfig.contains(key)) continue;
            this.mergedConfig.set(key, this.latestConfig.get(key));
        }
    }

    public boolean pushChanges() {
        try {
            this.mergedConfig.save(this.mergedFile);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean pushTo(File destinationFile) {
        if (this.mergedConfig == null) {
            return false;
        }
        try {
            this.mergedConfig.save(destinationFile);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

