/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.listeners;

import fr.fuzeblocks.homeplugin.event.OnEventAction;
import fr.fuzeblocks.homeplugin.event.OnHomeTeleportEvent;
import fr.fuzeblocks.homeplugin.event.OnRTPEvent;
import fr.fuzeblocks.homeplugin.event.OnSpawnTeleportEvent;
import fr.fuzeblocks.homeplugin.event.OnTpaAcceptedEvent;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class OnPlayerTakeDamageByAnotherPlayer
implements Listener {
    private static final long _COOLDOWN_MS = 5000L;
    private final Map<UUID, Long> playerDamageTimestamps = new ConcurrentHashMap<UUID, Long>();

    @EventHandler
    public void onPlayerDamage(EntityDamageByEntityEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        this.playerDamageTimestamps.put(event.getEntity().getUniqueId(), currentTime);
        this.playerDamageTimestamps.put(event.getDamager().getUniqueId(), currentTime);
    }

    @EventHandler
    public void onSpawnTeleport(OnSpawnTeleportEvent event) {
        this.checkCooldown(event);
    }

    @EventHandler
    public void onHomeTeleport(OnHomeTeleportEvent event) {
        this.checkCooldown(event);
    }

    @EventHandler
    public void onTpaAccepted(OnTpaAcceptedEvent event) {
        this.checkCooldown(event);
    }

    @EventHandler
    public void onRtpEvent(OnRTPEvent event) {
        this.checkCooldown(event);
    }

    private void checkCooldown(OnEventAction eventAction) {
        Player player = eventAction.getPlayer();
        if (player == null) {
            return;
        }
        UUID uuid = player.getUniqueId();
        Long lastHit = this.playerDamageTimestamps.get(uuid);
        if (lastHit == null) {
            return;
        }
        long elapsed = System.currentTimeMillis() - lastHit;
        if (elapsed < 5000L) {
            eventAction.setCancelled(true);
        } else {
            this.playerDamageTimestamps.remove(uuid);
        }
    }
}

