/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.rtp;

import fr.fuzeblocks.homeplugin.rtp.RtpRequestStore;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import redis.clients.jedis.JedisPooled;

public class RedisRtpRequestStore
implements RtpRequestStore {
    private static final String REDIS_KEY = "rtp_requests";
    private final JedisPooled jedis;

    public RedisRtpRequestStore(JedisPooled jedis) {
        this.jedis = jedis;
    }

    @Override
    public void addRtpRequest(UUID playerId, Long timestamp) {
        this.jedis.hset(REDIS_KEY, playerId.toString(), String.valueOf(timestamp));
    }

    @Override
    public Long getRtpRequest(UUID playerId) {
        String stored = this.jedis.hget(REDIS_KEY, playerId.toString());
        if (stored == null) {
            return null;
        }
        try {
            return Long.parseLong(stored);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public void removeRtpRequest(UUID playerId) {
        this.jedis.hdel(REDIS_KEY, playerId.toString());
    }

    @Override
    public boolean hasRtpRequest(UUID playerId) {
        return this.jedis.hexists(REDIS_KEY, playerId.toString());
    }

    @Override
    public Map<UUID, Long> getAllRtpRequests() {
        Map<String, String> entries = this.jedis.hgetAll(REDIS_KEY);
        return entries.entrySet().stream().map(entry -> {
            try {
                UUID uuid = UUID.fromString((String)entry.getKey());
                Long timestamp = Long.parseLong((String)entry.getValue());
                return Map.entry(uuid, timestamp);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

