/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.spawn;

import fr.fuzeblocks.homeplugin.spawn.SpawnRequestStore;
import org.bukkit.Location;
import org.bukkit.configuration.file.YamlConfiguration;
import redis.clients.jedis.JedisPooled;

public class RedisSpawnStore
implements SpawnRequestStore {
    private static final String SPAWN_KEY = "global_spawn";
    private final JedisPooled jedis;

    public RedisSpawnStore(JedisPooled jedis) {
        this.jedis = jedis;
    }

    @Override
    public Location getSpawn() {
        String data = this.jedis.get(SPAWN_KEY);
        if (data == null) {
            return null;
        }
        YamlConfiguration yaml = new YamlConfiguration();
        try {
            yaml.loadFromString(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return (Location)yaml.get("location");
    }

    @Override
    public void setSpawn(Location location) {
        YamlConfiguration yaml = new YamlConfiguration();
        yaml.set("location", (Object)location);
        String data = yaml.saveToString();
        this.jedis.set(SPAWN_KEY, data);
    }

    @Override
    public void clearSpawn() {
        this.jedis.del(SPAWN_KEY);
    }
}

