/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.spawn.yml;

import fr.fuzeblocks.homeplugin.spawn.Spawn;
import fr.fuzeblocks.homeplugin.status.StatusManager;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class SpawnYMLManager
implements Spawn {
    private final YamlConfiguration yaml;
    private final File file;

    public SpawnYMLManager(File file) {
        this.file = file;
        this.yaml = YamlConfiguration.loadConfiguration((File)file);
    }

    @Override
    public boolean setSpawn(Location location) {
        String key = "Spawn." + String.valueOf(location.getWorld().getUID());
        this.yaml.set(key + ".X", (Object)location.getX());
        this.yaml.set(key + ".Y", (Object)location.getY());
        this.yaml.set(key + ".Z", (Object)location.getZ());
        this.yaml.set(key + ".YAW", (Object)Float.valueOf(location.getYaw()));
        this.yaml.set(key + ".PITCH", (Object)Float.valueOf(location.getPitch()));
        this.yaml.set(key + ".World", (Object)location.getWorld().getName());
        try {
            this.yaml.save(this.file);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public Location getSpawn(World world) {
        String key = "Spawn." + String.valueOf(world.getUID());
        if (this.yaml.contains(key)) {
            return new Location(Bukkit.getWorld((String)this.yaml.getString(key + ".World")), this.yaml.getDouble(key + ".X"), this.yaml.getDouble(key + ".Y"), this.yaml.getDouble(key + ".Z"), (float)this.yaml.getDouble(key + ".YAW"), (float)this.yaml.getDouble(key + ".PITCH"));
        }
        return null;
    }

    @Override
    public boolean hasSpawn(World world) {
        String key = "Spawn." + String.valueOf(world.getUID());
        try {
            Objects.requireNonNull(this.yaml.getString(key)).equalsIgnoreCase(world.getUID().toString());
        }
        catch (NullPointerException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean removeSpawn(World world) {
        String key = "Spawn." + String.valueOf(world.getUID());
        this.yaml.set(key, null);
        try {
            this.yaml.save(this.file);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean isStatus(Player player) {
        return StatusManager.getPlayerStatus(player);
    }
}

