/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.task;

import fr.fuzeblocks.homeplugin.HomePlugin;
import fr.fuzeblocks.homeplugin.event.OnHomeTeleportEvent;
import fr.fuzeblocks.homeplugin.event.OnSpawnTeleportEvent;
import fr.fuzeblocks.homeplugin.status.StatusManager;
import fr.fuzeblocks.homeplugin.task.Task;
import fr.fuzeblocks.homeplugin.task.TaskSaveUtils;
import fr.fuzeblocks.homeplugin.task.exception.TeleportTaskException;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class TaskManager
extends BukkitRunnable {
    private final HomePlugin plugin = (HomePlugin)HomePlugin.getPlugin(HomePlugin.class);
    private Task task;
    private Player player;
    private BukkitTask teleportTask;
    private BukkitRunnable titleTask;
    private String homeName;
    private Location homeLocation;
    private final ConfigurationSection config = HomePlugin.getConfigurationSection();
    private final String LANG = "Language.";
    private final String TASK = "Config.Task.";

    public void run() {
        if (this.task.equals((Object)Task.HOME)) {
            this.teleportHome();
        } else if (this.task.equals((Object)Task.SPAWN)) {
            this.teleportSpawn();
        }
    }

    private void teleportHome() {
        OnHomeTeleportEvent onHomeTeleport = new OnHomeTeleportEvent(this.player, this.homeLocation, this.homeName);
        Bukkit.getServer().getPluginManager().callEvent((Event)onHomeTeleport);
        if (!onHomeTeleport.isCancelled()) {
            this.player.teleport(onHomeTeleport.getLocation());
            this.player.sendMessage(HomePlugin.getLanguageManager().getStringWithColor("Language.Teleport-to-home") + " " + this.homeName);
            this.player.resetTitle();
            if (this.config.getBoolean("Config.Task.Particles-After-Teleport")) {
                this.player.playEffect(this.homeLocation, Effect.MOBSPAWNER_FLAMES, 5000);
            }
        }
        StatusManager.setPlayerStatus(this.player, false);
        this.player.resetTitle();
    }

    private void teleportSpawn() {
        OnSpawnTeleportEvent onSpawnTeleport = new OnSpawnTeleportEvent(this.player, HomePlugin.getSpawnManager().getSpawn(this.player.getWorld()));
        Player target = onSpawnTeleport.getPlayer();
        Bukkit.getServer().getPluginManager().callEvent((Event)onSpawnTeleport);
        if (!onSpawnTeleport.isCancelled()) {
            target.teleport(onSpawnTeleport.getLocation());
            target.sendMessage(HomePlugin.getLanguageManager().getStringWithColor("Language.Teleport-to-spawn"));
            target.resetTitle();
        }
        StatusManager.setPlayerStatus(this.player, false);
        target.resetTitle();
    }

    public void startTeleportTask() {
        StatusManager.setPlayerStatus(this.player, true);
        TaskSaveUtils.setTaskManagerInstance(this.player, this);
        this.addTimeTitle(this.player);
        int duration = this.player.isOp() && this.config.getBoolean("Config.Task.Skip-If-Op") ? 0 : this.config.getInt("Config.Task.Task-Duration");
        this.teleportTask = this.runTaskLater((Plugin)this.plugin, 20L * (long)duration);
    }

    public void cancelTeleportTask() throws TeleportTaskException {
        if (this.teleportTask == null || this.teleportTask.isCancelled()) {
            throw new TeleportTaskException();
        }
        this.teleportTask.cancel();
        this.titleTask.cancel();
        this.player.resetTitle();
        this.player.sendMessage(HomePlugin.getLanguageManager().getStringWithColor("Language.Teleport-canceled"));
        StatusManager.setPlayerStatus(this.player, false);
    }

    public void homeTask(String homeName, Player player, Location location) {
        this.player = player;
        this.homeName = homeName;
        this.homeLocation = location;
        this.task = Task.HOME;
    }

    public void spawnTask(Player player) {
        this.player = player;
        this.task = Task.SPAWN;
    }

    private void addTimeTitle(final Player player) {
        final int duration = player.isOp() && this.config.getBoolean("Config.Task.Skip-If-Op") ? 0 : this.config.getInt("Config.Task.Task-Duration");
        this.titleTask = new BukkitRunnable(){
            int time;
            {
                this.time = duration;
            }

            public void run() {
                String key = "Language.Teleportation-in-progress";
                String message = HomePlugin.getLanguageManager().getStringWithColor(key) + " ";
                if (TaskManager.this.config.getBoolean("Config.Task.Use-Title")) {
                    player.sendTitle(message, String.valueOf(this.time), 0, 20, 0);
                }
                if (TaskManager.this.config.getBoolean("Config.Task.Use-Message")) {
                    player.sendMessage(message + this.time);
                }
                --this.time;
                if (this.time <= 0) {
                    player.resetTitle();
                    this.cancel();
                }
            }
        };
        this.titleTask.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    public Player getPlayer() {
        return this.player;
    }

    public Task getTask() {
        return this.task;
    }

    public String getHomeName() {
        return this.homeName;
    }

    public Location getHomeLocation() {
        return this.homeLocation;
    }
}

