/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.task;

import fr.fuzeblocks.homeplugin.HomePlugin;
import fr.fuzeblocks.homeplugin.language.LanguageManager;
import fr.fuzeblocks.homeplugin.status.StatusManager;
import fr.fuzeblocks.homeplugin.task.TaskManager;
import fr.fuzeblocks.homeplugin.task.TaskSaveUtils;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class TeleportationManager {
    private static final String HOME = "Home.";
    private static final LanguageManager languageManager = HomePlugin.getLanguageManager();

    public static void teleportPlayerToHome(Player player, String homeName) {
        TeleportationManager.sendHomeTeleportMessage(player, homeName);
        Location location = HomePlugin.getHomeManager().getHomeLocation(player, homeName);
        if (location.getWorld() == null) {
            player.sendMessage(languageManager.getStringWithColor("Home.Home-world-not-loaded"));
        }
        TaskManager taskManager = new TaskManager();
        taskManager.homeTask(homeName, player, location);
        taskManager.startTeleportTask();
        StatusManager.setPlayerStatus(player, true);
        TeleportationManager.setTaskManagerInstance(player, taskManager);
    }

    public static void teleportPlayerToSpawn(Player player) {
        TeleportationManager.sendSpawnTeleportMessage(player);
        TaskManager taskManager = new TaskManager();
        taskManager.spawnTask(player);
        taskManager.startTeleportTask();
        TeleportationManager.setTaskManagerInstance(player, taskManager);
        StatusManager.setPlayerStatus(player, true);
    }

    private static void sendSpawnTeleportMessage(Player player) {
        player.sendMessage(HomePlugin.getLanguageManager().getStringWithColor("Language.Start-of-teleportation-for-spawn"));
    }

    private static void sendHomeTeleportMessage(Player player, String homeName) {
        player.sendMessage(HomePlugin.getLanguageManager().getStringWithColor("Language.Start-of-teleportation") + " " + homeName);
    }

    private static void setTaskManagerInstance(Player player, TaskManager taskManager) {
        TaskSaveUtils.setTaskManagerInstance(player, taskManager);
    }
}

