/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.tpa;

import fr.fuzeblocks.homeplugin.tpa.TpaRequestStore;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class LocalTpaRequestStore
implements TpaRequestStore {
    private final Map<UUID, UUID> tpaRequests = new HashMap<UUID, UUID>();

    @Override
    public void addTpaRequest(UUID sender, UUID target) {
        this.tpaRequests.put(sender, target);
    }

    @Override
    public boolean hasTpaRequest(UUID sender, UUID target) {
        return target.equals(this.tpaRequests.get(sender));
    }

    @Override
    public void removeTpaRequest(UUID sender, UUID target) {
        if (target.equals(this.tpaRequests.get(sender))) {
            this.tpaRequests.remove(sender);
        }
    }

    @Override
    public UUID getTargetWithSender(UUID sender) {
        return this.tpaRequests.get(sender);
    }

    @Override
    public boolean hasIncomingTpa(UUID target) {
        return this.tpaRequests.containsValue(target);
    }

    @Override
    public UUID getSenderForTarget(UUID target) {
        return this.tpaRequests.entrySet().stream().filter(entry -> ((UUID)entry.getValue()).equals(target)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    @Override
    public UUID getTpaTarget(UUID senderId) {
        return this.tpaRequests.get(senderId);
    }

    @Override
    public Set<UUID> getAllTpaSenders() {
        return this.tpaRequests.keySet();
    }
}

