/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.inventoryaccess.component;

import fr.fuzeblocks.libs.net.kyori.adventure.text.Component;
import fr.fuzeblocks.libs.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.inventoryaccess.component.ComponentWrapper;
import xyz.xenondevs.inventoryaccess.component.i18n.AdventureComponentLocalizer;
import xyz.xenondevs.inventoryaccess.component.i18n.Languages;
import xyz.xenondevs.inventoryaccess.util.AdventureComponentUtils;

public class AdventureComponentWrapper
implements ComponentWrapper {
    public static final AdventureComponentWrapper EMPTY = new AdventureComponentWrapper(Component.empty());
    private final Component component;

    public AdventureComponentWrapper(Component component) {
        this.component = component;
    }

    @Override
    @NotNull
    public String serializeToJson() {
        return (String)GsonComponentSerializer.gson().serialize(this.component);
    }

    @Override
    @NotNull
    public AdventureComponentWrapper localized(@NotNull String lang) {
        if (!Languages.getInstance().doesServerSideTranslations()) {
            return this;
        }
        return new AdventureComponentWrapper(AdventureComponentLocalizer.getInstance().localize(lang, this.component));
    }

    @Override
    @NotNull
    public AdventureComponentWrapper withoutPreFormatting() {
        return new AdventureComponentWrapper(AdventureComponentUtils.withoutPreFormatting(this.component));
    }

    @Override
    @NotNull
    public AdventureComponentWrapper clone() {
        try {
            return (AdventureComponentWrapper)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

