/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.inventoryaccess.component.i18n;

import java.util.List;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import xyz.xenondevs.inventoryaccess.component.i18n.ComponentLocalizer;
import xyz.xenondevs.inventoryaccess.component.i18n.Languages;

public class BungeeComponentLocalizer
extends ComponentLocalizer<BaseComponent> {
    private static final BungeeComponentLocalizer INSTANCE = new BungeeComponentLocalizer();

    private BungeeComponentLocalizer() {
        super(TextComponent::new);
    }

    public static BungeeComponentLocalizer getInstance() {
        return INSTANCE;
    }

    @Override
    public BaseComponent[] localize(String lang, BaseComponent[] components) {
        BaseComponent[] localizedComponents = new BaseComponent[components.length];
        for (int i = 0; i < components.length; ++i) {
            localizedComponents[i] = this.localize(lang, components[i]);
        }
        return localizedComponents;
    }

    @Override
    public BaseComponent localize(String lang, BaseComponent component) {
        BaseComponent duplicate = component instanceof TranslatableComponent ? this.localizeTranslatable(lang, (TranslatableComponent)component) : component.duplicate();
        List extra = duplicate.getExtra();
        if (extra != null) {
            duplicate.setExtra(extra.stream().map(child -> this.localize(lang, (BaseComponent)child)).collect(Collectors.toList()));
        }
        return duplicate;
    }

    private BaseComponent localizeTranslatable(String lang, TranslatableComponent component) {
        String formatString = Languages.getInstance().getFormatString(lang, component.getTranslate());
        if (formatString == null) {
            return component;
        }
        List<TranslatableComponent> children = this.decomposeFormatString(lang, formatString, component, component.getWith());
        TextComponent result = new TextComponent((BaseComponent[])children.toArray(BaseComponent[]::new));
        result.copyFormatting((BaseComponent)component);
        List extra = component.getExtra();
        if (extra != null) {
            result.setExtra(extra);
        }
        return result;
    }
}

