/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.inventoryaccess.component.i18n;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class ComponentLocalizer<C> {
    private static final Pattern FORMAT_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");
    private Function<String, C> componentCreator;

    public ComponentLocalizer(Function<String, C> componentCreator) {
        this.componentCreator = componentCreator;
    }

    public void setComponentCreator(Function<String, C> componentCreator) {
        this.componentCreator = componentCreator;
    }

    public abstract C localize(String var1, C var2);

    protected List<C> decomposeFormatString(String lang, String formatString, C component, List<C> args) {
        Matcher matcher = FORMAT_PATTERN.matcher(formatString);
        ArrayList<C> components = new ArrayList<C>();
        StringBuilder sb = new StringBuilder();
        int nextArgIdx = 0;
        int i = 0;
        while (matcher.find(i)) {
            int end;
            int start = matcher.start();
            String matchedStr = formatString.substring(start, end = matcher.end());
            if ("%%".equals(matchedStr)) {
                sb.append('%');
            } else {
                int argIdx;
                String argType = matcher.group(2);
                if (!"s".equals(argType)) {
                    throw new IllegalStateException("Unsupported placeholder format: '" + matchedStr + "'");
                }
                String argIdxStr = matcher.group(1);
                int n = argIdx = argIdxStr == null ? nextArgIdx++ : Integer.parseInt(argIdxStr) - 1;
                if (argIdx < 0) {
                    throw new IllegalStateException("Invalid argument index: " + argIdx);
                }
                sb.append(formatString, i, start);
                components.add(this.componentCreator.apply(sb.toString()));
                components.add(args.size() <= argIdx ? this.componentCreator.apply("") : this.localize(lang, args.get(argIdx)));
                sb.setLength(0);
            }
            i = end;
        }
        if (i < formatString.length()) {
            sb.append(formatString, i, formatString.length());
            components.add(this.componentCreator.apply(sb.toString()));
        }
        return components;
    }
}

