/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.inventoryaccess.component.i18n;

import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Languages {
    private static final Languages INSTANCE = new Languages();
    private final Map<String, Map<String, String>> translations = new HashMap<String, Map<String, String>>();
    private Function<Player, String> languageProvider = Player::getLocale;
    private boolean serverSideTranslations = true;

    private Languages() {
    }

    @NotNull
    public static Languages getInstance() {
        return INSTANCE;
    }

    public void addLanguage(@NotNull String lang, @NotNull @NotNull Map<@NotNull String, @NotNull String> translations) {
        this.translations.put(lang, translations);
    }

    public void loadLanguage(@NotNull String lang, @NotNull Reader reader) throws IOException {
        HashMap<String, String> translations = new HashMap<String, String>();
        try (JsonReader jsonReader = new JsonReader(reader);){
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                String key = jsonReader.nextName();
                String value = jsonReader.nextString();
                translations.put(key, value);
            }
            this.addLanguage(lang, translations);
        }
    }

    public void loadLanguage(@NotNull String lang, @NotNull File file, @NotNull Charset charset) throws IOException {
        try (FileReader reader = new FileReader(file, charset);){
            this.loadLanguage(lang, reader);
        }
    }

    @Nullable
    public String getFormatString(@NotNull String lang, @NotNull String key) {
        Map<String, String> map = this.translations.get(lang);
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public void setLanguageProvider(@NotNull @NotNull Function<@NotNull Player, @NotNull String> languageProvider) {
        this.languageProvider = languageProvider;
    }

    @NotNull
    public String getLanguage(@NotNull Player player) {
        return this.languageProvider.apply(player);
    }

    public void enableServerSideTranslations(boolean enable) {
        this.serverSideTranslations = enable;
    }

    public boolean doesServerSideTranslations() {
        return this.serverSideTranslations;
    }
}

