/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.inventoryaccess.r2;

import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.server.v1_14_R1.BlockPosition;
import net.minecraft.server.v1_14_R1.Container;
import net.minecraft.server.v1_14_R1.ContainerAccess;
import net.minecraft.server.v1_14_R1.ContainerAnvil;
import net.minecraft.server.v1_14_R1.Containers;
import net.minecraft.server.v1_14_R1.EntityHuman;
import net.minecraft.server.v1_14_R1.EntityPlayer;
import net.minecraft.server.v1_14_R1.IChatBaseComponent;
import net.minecraft.server.v1_14_R1.IInventory;
import net.minecraft.server.v1_14_R1.NonNullList;
import net.minecraft.server.v1_14_R1.Packet;
import net.minecraft.server.v1_14_R1.PacketPlayOutOpenWindow;
import net.minecraft.server.v1_14_R1.PacketPlayOutSetSlot;
import net.minecraft.server.v1_14_R1.PacketPlayOutWindowItems;
import net.minecraft.server.v1_14_R1.World;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_14_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_14_R1.inventory.CraftInventoryAnvil;
import org.bukkit.craftbukkit.v1_14_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_14_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.inventoryaccess.abstraction.inventory.AnvilInventory;
import xyz.xenondevs.inventoryaccess.component.ComponentWrapper;
import xyz.xenondevs.inventoryaccess.r2.InventoryUtilsImpl;
import xyz.xenondevs.inventoryaccess.util.ReflectionUtils;

class AnvilInventoryImpl
extends ContainerAnvil
implements AnvilInventory {
    private static final Field CONTAINER_ACCESS_FIELD = ReflectionUtils.getField(ContainerAnvil.class, true, "containerAccess");
    private static final Field REPAIR_INVENTORY_FIELD = ReflectionUtils.getField(ContainerAnvil.class, true, "repairInventory");
    private static final Field RESULT_INVENTORY_FIELD = ReflectionUtils.getField(ContainerAnvil.class, true, "resultInventory");
    private final IChatBaseComponent title;
    private final List<Consumer<String>> renameHandlers;
    private final CraftInventoryView view;
    private final EntityPlayer player;
    private final IInventory repairInventory;
    private final IInventory resultInventory;
    private String text;
    private boolean open;

    public AnvilInventoryImpl(Player player, @NotNull ComponentWrapper title, List<Consumer<String>> renameHandlers) {
        this(((CraftPlayer)player).getHandle(), InventoryUtilsImpl.createNMSComponent(title), renameHandlers);
    }

    public AnvilInventoryImpl(EntityPlayer player, IChatBaseComponent title, List<Consumer<String>> renameHandlers) {
        super(player.nextContainerCounter(), player.inventory, ContainerAccess.at((World)player.getWorld(), (BlockPosition)new BlockPosition(0, 0, 0)));
        this.title = title;
        this.renameHandlers = renameHandlers;
        this.player = player;
        this.repairInventory = (IInventory)ReflectionUtils.getFieldValue(REPAIR_INVENTORY_FIELD, this);
        this.resultInventory = (IInventory)ReflectionUtils.getFieldValue(RESULT_INVENTORY_FIELD, this);
        ContainerAccess containerAccess = (ContainerAccess)ReflectionUtils.getFieldValue(CONTAINER_ACCESS_FIELD, this);
        CraftInventoryAnvil inventory = new CraftInventoryAnvil(containerAccess.getLocation(), this.repairInventory, this.resultInventory, (ContainerAnvil)this);
        this.view = new CraftInventoryView((HumanEntity)player.getBukkitEntity(), (Inventory)inventory, (Container)this);
    }

    @Override
    public void open() {
        this.open = true;
        CraftEventFactory.callInventoryOpenEvent((EntityPlayer)this.player, (Container)this);
        this.player.activeContainer = this;
        this.player.playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(this.windowId, Containers.ANVIL, this.title));
        NonNullList itemsList = NonNullList.a((Object)net.minecraft.server.v1_14_R1.ItemStack.a, (Object[])new net.minecraft.server.v1_14_R1.ItemStack[]{this.getItem(0), this.getItem(1), this.getItem(2)});
        this.player.playerConnection.sendPacket((Packet)new PacketPlayOutWindowItems(InventoryUtilsImpl.getActiveWindowId(this.player), itemsList));
    }

    public void sendItem(int slot) {
        this.player.playerConnection.sendPacket((Packet)new PacketPlayOutSetSlot(InventoryUtilsImpl.getActiveWindowId(this.player), slot, this.getItem(slot)));
    }

    public void setItem(int slot, net.minecraft.server.v1_14_R1.ItemStack item) {
        if (slot < 2) {
            this.repairInventory.setItem(slot, item);
        } else {
            this.resultInventory.setItem(0, item);
        }
        if (this.open) {
            this.sendItem(slot);
        }
    }

    private net.minecraft.server.v1_14_R1.ItemStack getItem(int slot) {
        if (slot < 2) {
            return this.repairInventory.getItem(slot);
        }
        return this.resultInventory.getItem(0);
    }

    @Override
    public void setItem(int slot, ItemStack itemStack) {
        this.setItem(slot, CraftItemStack.asNMSCopy((ItemStack)itemStack));
    }

    @Override
    @NotNull
    public Inventory getBukkitInventory() {
        return this.view.getTopInventory();
    }

    @Override
    public String getRenameText() {
        return this.text;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    public CraftInventoryView getBukkitView() {
        return this.view;
    }

    public boolean canUse(EntityHuman entityhuman) {
        return true;
    }

    public void a(String s) {
        this.text = s;
        if (this.renameHandlers != null) {
            this.renameHandlers.forEach(handler -> handler.accept(s));
        }
        this.sendItem(2);
    }

    public void b(EntityHuman entityhuman) {
        this.open = false;
    }

    public void e() {
    }
}

