/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.inventoryaccess.r2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.server.v1_14_R1.NBTCompressedStreamTools;
import net.minecraft.server.v1_14_R1.NBTTagCompound;
import org.bukkit.craftbukkit.v1_14_R1.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.inventoryaccess.abstraction.util.ItemUtils;
import xyz.xenondevs.inventoryaccess.component.ComponentWrapper;
import xyz.xenondevs.inventoryaccess.r2.InventoryUtilsImpl;
import xyz.xenondevs.inventoryaccess.util.ReflectionRegistry;
import xyz.xenondevs.inventoryaccess.util.ReflectionUtils;

class ItemUtilsImpl
implements ItemUtils {
    ItemUtilsImpl() {
    }

    @Override
    public byte[] serializeItemStack(@NotNull ItemStack itemStack, boolean compressed) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.serializeItemStack(itemStack, out, compressed);
        return out.toByteArray();
    }

    @Override
    public void serializeItemStack(@NotNull ItemStack itemStack, @NotNull OutputStream out, boolean compressed) {
        try {
            net.minecraft.server.v1_14_R1.ItemStack nmsStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
            NBTTagCompound nbt = nmsStack.save(new NBTTagCompound());
            if (compressed) {
                NBTCompressedStreamTools.a((NBTTagCompound)nbt, (OutputStream)out);
            } else {
                DataOutputStream dataOut = new DataOutputStream(out);
                NBTCompressedStreamTools.a((NBTTagCompound)nbt, (DataOutput)dataOut);
            }
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ItemStack deserializeItemStack(byte[] data, boolean compressed) {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        return this.deserializeItemStack(in, compressed);
    }

    @Override
    public ItemStack deserializeItemStack(@NotNull InputStream in, boolean compressed) {
        try {
            NBTTagCompound nbt;
            if (compressed) {
                nbt = NBTCompressedStreamTools.a((InputStream)in);
            } else {
                DataInputStream dataIn = new DataInputStream(in);
                nbt = NBTCompressedStreamTools.a((DataInputStream)dataIn);
            }
            net.minecraft.server.v1_14_R1.ItemStack itemStack = net.minecraft.server.v1_14_R1.ItemStack.a((NBTTagCompound)nbt);
            return CraftItemStack.asCraftMirror((net.minecraft.server.v1_14_R1.ItemStack)itemStack);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setDisplayName(@NotNull ItemMeta itemMeta, @NotNull ComponentWrapper name) {
        ReflectionUtils.setFieldValue(ReflectionRegistry.CB_CRAFT_META_ITEM_DISPLAY_NAME_FIELD, itemMeta, InventoryUtilsImpl.createNMSComponent(name));
    }

    @Override
    public void setLore(@NotNull ItemMeta itemMeta, @NotNull @NotNull List<@NotNull ComponentWrapper> lore) {
        ReflectionUtils.setFieldValue(ReflectionRegistry.CB_CRAFT_META_ITEM_LORE_FIELD, itemMeta, lore.stream().map(InventoryUtilsImpl::createNMSComponent).collect(Collectors.toList()));
    }
}

