/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.inventoryaccess.r23;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.inventoryaccess.abstraction.util.PlayerUtils;
import xyz.xenondevs.inventoryaccess.map.MapIcon;
import xyz.xenondevs.inventoryaccess.map.MapPatch;
import xyz.xenondevs.inventoryaccess.r23.InventoryUtilsImpl;
import xyz.xenondevs.inventoryaccess.util.ReflectionUtils;

class PlayerUtilsImpl
implements PlayerUtils {
    private static final Method REGISTER_LISTENERS_METHOD = ReflectionUtils.getMethod(AdvancementDataPlayer.class, true, "b", AdvancementDataWorld.class);

    PlayerUtilsImpl() {
    }

    @Override
    public void stopAdvancementListening(@NotNull Player player) {
        this.stopAdvancementListening(((CraftPlayer)player).getHandle());
    }

    @Override
    public void stopAdvancementListening(@NotNull Object player) {
        ((EntityPlayer)player).R().a();
    }

    @Override
    public void startAdvancementListening(@NotNull Player player) {
        this.startAdvancementListening(((CraftPlayer)player).getHandle());
    }

    @Override
    public void startAdvancementListening(@NotNull Object player) {
        AdvancementDataPlayer advancements = ((EntityPlayer)player).R();
        AdvancementDataWorld manager = ((CraftServer)Bukkit.getServer()).getServer().aD();
        ReflectionUtils.invokeMethod(REGISTER_LISTENERS_METHOD, advancements, manager);
    }

    @Override
    public void sendMapUpdate(@NotNull Player player, int mapId, byte scale, boolean locked, @Nullable MapPatch mapPatch, @Nullable List<xyz.xenondevs.inventoryaccess.map.MapIcon> icons) {
        List decorations = icons != null ? (List)icons.stream().map(this::toMapDecoration).collect(Collectors.toCollection(ArrayList::new)) : null;
        WorldMap.c patch = this.toMapPatch(mapPatch);
        PacketPlayOutMap packet = new PacketPlayOutMap(new MapId(mapId), scale, locked, (Collection)decorations, patch);
        ((CraftPlayer)player).getHandle().f.b((Packet)packet);
    }

    private MapIcon toMapDecoration(xyz.xenondevs.inventoryaccess.map.MapIcon icon) {
        return new MapIcon(this.getDecorationTypeByIconType(icon.getType()), icon.getX(), icon.getY(), icon.getRot(), Optional.ofNullable(icon.getComponent()).map(InventoryUtilsImpl::createNMSComponent));
    }

    private WorldMap.c toMapPatch(MapPatch patch) {
        if (patch == null) {
            return null;
        }
        return new WorldMap.c(patch.getStartX(), patch.getStartY(), patch.getWidth(), patch.getHeight(), patch.getColors());
    }

    private Holder<MapDecorationType> getDecorationTypeByIconType(MapIcon.MapIconType icon) {
        return switch (icon) {
            default -> throw new MatchException(null, null);
            case MapIcon.MapIconType.WHITE_ARROW -> MapDecorationTypes.a;
            case MapIcon.MapIconType.GREEN_ARROW -> MapDecorationTypes.b;
            case MapIcon.MapIconType.RED_ARROW -> MapDecorationTypes.c;
            case MapIcon.MapIconType.BLUE_ARROW -> MapDecorationTypes.d;
            case MapIcon.MapIconType.WHITE_CROSS -> MapDecorationTypes.e;
            case MapIcon.MapIconType.RED_POINTER -> MapDecorationTypes.f;
            case MapIcon.MapIconType.WHITE_CIRCLE -> MapDecorationTypes.g;
            case MapIcon.MapIconType.SMALL_WHITE_CIRCLE -> MapDecorationTypes.h;
            case MapIcon.MapIconType.MANSION -> MapDecorationTypes.i;
            case MapIcon.MapIconType.TEMPLE -> MapDecorationTypes.G;
            case MapIcon.MapIconType.WHITE_BANNER -> MapDecorationTypes.k;
            case MapIcon.MapIconType.ORANGE_BANNER -> MapDecorationTypes.l;
            case MapIcon.MapIconType.MAGENTA_BANNER -> MapDecorationTypes.m;
            case MapIcon.MapIconType.LIGHT_BLUE_BANNER -> MapDecorationTypes.n;
            case MapIcon.MapIconType.YELLOW_BANNER -> MapDecorationTypes.o;
            case MapIcon.MapIconType.LIME_BANNER -> MapDecorationTypes.p;
            case MapIcon.MapIconType.PINK_BANNER -> MapDecorationTypes.q;
            case MapIcon.MapIconType.GRAY_BANNER -> MapDecorationTypes.r;
            case MapIcon.MapIconType.LIGHT_GRAY_BANNER -> MapDecorationTypes.s;
            case MapIcon.MapIconType.CYAN_BANNER -> MapDecorationTypes.t;
            case MapIcon.MapIconType.PURPLE_BANNER -> MapDecorationTypes.u;
            case MapIcon.MapIconType.BLUE_BANNER -> MapDecorationTypes.v;
            case MapIcon.MapIconType.BROWN_BANNER -> MapDecorationTypes.w;
            case MapIcon.MapIconType.GREEN_BANNER -> MapDecorationTypes.x;
            case MapIcon.MapIconType.RED_BANNER -> MapDecorationTypes.y;
            case MapIcon.MapIconType.BLACK_BANNER -> MapDecorationTypes.z;
            case MapIcon.MapIconType.RED_CROSS -> MapDecorationTypes.A;
        };
    }
}

