/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.inventoryaccess.r3;

import net.minecraft.server.v1_14_R1.ChatComponentText;
import net.minecraft.server.v1_14_R1.Container;
import net.minecraft.server.v1_14_R1.Containers;
import net.minecraft.server.v1_14_R1.EntityHuman;
import net.minecraft.server.v1_14_R1.EntityPlayer;
import net.minecraft.server.v1_14_R1.IChatBaseComponent;
import net.minecraft.server.v1_14_R1.ICrafting;
import net.minecraft.server.v1_14_R1.IInventory;
import net.minecraft.server.v1_14_R1.ITileInventory;
import net.minecraft.server.v1_14_R1.Packet;
import net.minecraft.server.v1_14_R1.PacketPlayOutOpenWindow;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_14_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_14_R1.inventory.CraftContainer;
import org.bukkit.craftbukkit.v1_14_R1.inventory.CraftInventory;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.inventoryaccess.abstraction.util.InventoryUtils;
import xyz.xenondevs.inventoryaccess.component.ComponentWrapper;

class InventoryUtilsImpl
implements InventoryUtils {
    InventoryUtilsImpl() {
    }

    private static Containers<?> getNotchInventoryType(Inventory inventory) {
        InventoryType type = inventory.getType();
        if (type == InventoryType.CHEST) {
            switch (inventory.getSize()) {
                case 9: {
                    return Containers.GENERIC_9X1;
                }
                case 18: {
                    return Containers.GENERIC_9X2;
                }
                case 27: {
                    return Containers.GENERIC_9X3;
                }
                case 36: {
                    return Containers.GENERIC_9X4;
                }
                case 45: {
                    return Containers.GENERIC_9X5;
                }
                case 54: {
                    return Containers.GENERIC_9X6;
                }
            }
            throw new IllegalArgumentException("Unsupported custom inventory size " + inventory.getSize());
        }
        return CraftContainer.getNotchInventoryType((InventoryType)type);
    }

    public static IChatBaseComponent createNMSComponent(ComponentWrapper component) {
        return IChatBaseComponent.ChatSerializer.a((String)component.serializeToJson());
    }

    public static int getActiveWindowId(EntityPlayer player) {
        Container container = player.activeContainer;
        return container == null ? -1 : container.windowId;
    }

    @Override
    public void openCustomInventory(@NotNull Player player, @NotNull Inventory inventory) {
        this.openCustomInventory(player, inventory, null);
    }

    @Override
    public void openCustomInventory(@NotNull Player player, @NotNull Inventory inventory, @Nullable ComponentWrapper title) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        Containers<?> windowType = InventoryUtilsImpl.getNotchInventoryType(inventory);
        if (entityPlayer.playerConnection != null) {
            CraftContainer container = new CraftContainer(inventory, (EntityHuman)entityPlayer, entityPlayer.nextContainerCounter());
            if ((container = CraftEventFactory.callInventoryOpenEvent((EntityPlayer)entityPlayer, (Container)container)) != null) {
                IInventory iinventory = ((CraftInventory)inventory).getInventory();
                Object titleComponent = title == null ? (iinventory instanceof ITileInventory ? ((ITileInventory)iinventory).getScoreboardDisplayName() : new ChatComponentText(container.getBukkitView().getTitle())) : InventoryUtilsImpl.createNMSComponent(title);
                entityPlayer.playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(container.windowId, windowType, titleComponent));
                entityPlayer.activeContainer = container;
                entityPlayer.activeContainer.addSlotListener((ICrafting)entityPlayer);
            }
        }
    }

    @Override
    public void updateOpenInventoryTitle(@NotNull Player player, @NotNull ComponentWrapper title) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        Container container = entityPlayer.activeContainer;
        entityPlayer.playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(container.windowId, container.getType(), InventoryUtilsImpl.createNMSComponent(title)));
        entityPlayer.updateInventory(container);
    }

    @Override
    @Nullable
    public ItemStack getItemStackFromView(@NotNull InventoryView view, int slot) {
        return view.getItem(slot);
    }
}

