/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.inventoryaccess.r6;

import java.lang.reflect.Field;
import net.minecraft.server.v1_16_R2.BlockPosition;
import net.minecraft.server.v1_16_R2.Container;
import net.minecraft.server.v1_16_R2.ContainerAccess;
import net.minecraft.server.v1_16_R2.ContainerCartography;
import net.minecraft.server.v1_16_R2.Containers;
import net.minecraft.server.v1_16_R2.EntityHuman;
import net.minecraft.server.v1_16_R2.EntityPlayer;
import net.minecraft.server.v1_16_R2.IChatBaseComponent;
import net.minecraft.server.v1_16_R2.IInventory;
import net.minecraft.server.v1_16_R2.InventoryCraftResult;
import net.minecraft.server.v1_16_R2.NonNullList;
import net.minecraft.server.v1_16_R2.Packet;
import net.minecraft.server.v1_16_R2.PacketPlayOutOpenWindow;
import net.minecraft.server.v1_16_R2.PacketPlayOutSetSlot;
import net.minecraft.server.v1_16_R2.PacketPlayOutWindowItems;
import net.minecraft.server.v1_16_R2.Slot;
import net.minecraft.server.v1_16_R2.World;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_16_R2.inventory.CraftInventoryCartography;
import org.bukkit.craftbukkit.v1_16_R2.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_16_R2.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.inventoryaccess.abstraction.inventory.CartographyInventory;
import xyz.xenondevs.inventoryaccess.component.ComponentWrapper;
import xyz.xenondevs.inventoryaccess.r6.InventoryUtilsImpl;
import xyz.xenondevs.inventoryaccess.util.ReflectionUtils;

class CartographyInventoryImpl
extends ContainerCartography
implements CartographyInventory {
    private static final Field RESULT_CONTAINER_FIELD = ReflectionUtils.getField(ContainerCartography.class, true, "resultInventory");
    private final InventoryCraftResult resultInventory = (InventoryCraftResult)ReflectionUtils.getFieldValue(RESULT_CONTAINER_FIELD, this);
    private final IChatBaseComponent title;
    private final CraftInventoryView view;
    private final EntityPlayer player;
    private boolean open;

    public CartographyInventoryImpl(Player player, @NotNull ComponentWrapper title) {
        this(((CraftPlayer)player).getHandle(), InventoryUtilsImpl.createNMSComponent(title));
    }

    public CartographyInventoryImpl(EntityPlayer player, IChatBaseComponent title) {
        super(player.nextContainerCounter(), player.inventory, ContainerAccess.at((World)player.getWorld(), (BlockPosition)new BlockPosition(0, 0, 0)));
        this.player = player;
        this.title = title;
        CraftInventoryCartography inventory = new CraftInventoryCartography(this.inventory, (IInventory)this.resultInventory);
        this.view = new CraftInventoryView((HumanEntity)player.getBukkitEntity(), (Inventory)inventory, (Container)this);
    }

    @Override
    public void open() {
        this.open = true;
        CraftEventFactory.callInventoryOpenEvent((EntityPlayer)this.player, (Container)this);
        this.player.activeContainer = this;
        this.player.playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(this.windowId, Containers.CARTOGRAPHY_TABLE, this.title));
        NonNullList itemsList = NonNullList.a((Object)net.minecraft.server.v1_16_R2.ItemStack.b, (Object[])new net.minecraft.server.v1_16_R2.ItemStack[]{this.getItem(0), this.getItem(1), this.getItem(2)});
        this.player.playerConnection.sendPacket((Packet)new PacketPlayOutWindowItems(InventoryUtilsImpl.getActiveWindowId(this.player), itemsList));
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    public void sendItem(int slot) {
        this.player.playerConnection.sendPacket((Packet)new PacketPlayOutSetSlot(InventoryUtilsImpl.getActiveWindowId(this.player), slot, this.getItem(slot)));
    }

    public void setItem(int slot, net.minecraft.server.v1_16_R2.ItemStack item) {
        if (slot < 2) {
            this.inventory.setItem(slot, item);
        } else {
            this.resultInventory.setItem(0, item);
        }
        if (this.open) {
            this.sendItem(slot);
        }
    }

    private net.minecraft.server.v1_16_R2.ItemStack getItem(int slot) {
        if (slot < 2) {
            return this.inventory.getItem(slot);
        }
        return this.resultInventory.getItem(0);
    }

    @Override
    public void setItem(int slot, ItemStack itemStack) {
        this.setItem(slot, CraftItemStack.asNMSCopy((ItemStack)itemStack));
    }

    @Override
    public Inventory getBukkitInventory() {
        return this.view.getTopInventory();
    }

    public CraftInventoryView getBukkitView() {
        return this.view;
    }

    public void a(IInventory inventory) {
    }

    public net.minecraft.server.v1_16_R2.ItemStack shiftClick(EntityHuman entityhuman, int i) {
        return net.minecraft.server.v1_16_R2.ItemStack.b;
    }

    public boolean a(net.minecraft.server.v1_16_R2.ItemStack itemstack, Slot slot) {
        return true;
    }

    public boolean canUse(EntityHuman entityhuman) {
        return true;
    }

    public void b(EntityHuman entityHuman) {
    }
}

