/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.inventoryaccess.r7;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.Container;
import net.minecraft.server.v1_16_R3.ContainerAccess;
import net.minecraft.server.v1_16_R3.ContainerAnvil;
import net.minecraft.server.v1_16_R3.Containers;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.IChatBaseComponent;
import net.minecraft.server.v1_16_R3.IInventory;
import net.minecraft.server.v1_16_R3.NonNullList;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketPlayOutOpenWindow;
import net.minecraft.server.v1_16_R3.PacketPlayOutSetSlot;
import net.minecraft.server.v1_16_R3.PacketPlayOutWindowItems;
import net.minecraft.server.v1_16_R3.World;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventoryAnvil;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.inventoryaccess.abstraction.inventory.AnvilInventory;
import xyz.xenondevs.inventoryaccess.component.ComponentWrapper;
import xyz.xenondevs.inventoryaccess.r7.InventoryUtilsImpl;

class AnvilInventoryImpl
extends ContainerAnvil
implements AnvilInventory {
    private final IChatBaseComponent title;
    private final List<Consumer<String>> renameHandlers;
    private final CraftInventoryView view;
    private final EntityPlayer player;
    private String text;
    private boolean open;

    public AnvilInventoryImpl(Player player, @NotNull ComponentWrapper title, List<Consumer<String>> renameHandlers) {
        this(((CraftPlayer)player).getHandle(), InventoryUtilsImpl.createNMSComponent(title), renameHandlers);
    }

    public AnvilInventoryImpl(EntityPlayer player, IChatBaseComponent title, List<Consumer<String>> renameHandlers) {
        super(player.nextContainerCounter(), player.inventory, ContainerAccess.at((World)player.getWorld(), (BlockPosition)new BlockPosition(0, 0, 0)));
        this.title = title;
        this.renameHandlers = renameHandlers;
        this.player = player;
        CraftInventoryAnvil inventory = new CraftInventoryAnvil(this.containerAccess.getLocation(), this.repairInventory, (IInventory)this.resultInventory, (ContainerAnvil)this);
        this.view = new CraftInventoryView((HumanEntity)player.getBukkitEntity(), (Inventory)inventory, (Container)this);
    }

    @Override
    public void open() {
        this.open = true;
        CraftEventFactory.callInventoryOpenEvent((EntityPlayer)this.player, (Container)this);
        this.player.activeContainer = this;
        this.player.playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(this.windowId, Containers.ANVIL, this.title));
        NonNullList itemsList = NonNullList.a((Object)net.minecraft.server.v1_16_R3.ItemStack.b, (Object[])new net.minecraft.server.v1_16_R3.ItemStack[]{this.getItem(0), this.getItem(1), this.getItem(2)});
        this.player.playerConnection.sendPacket((Packet)new PacketPlayOutWindowItems(InventoryUtilsImpl.getActiveWindowId(this.player), itemsList));
    }

    public void sendItem(int slot) {
        this.player.playerConnection.sendPacket((Packet)new PacketPlayOutSetSlot(InventoryUtilsImpl.getActiveWindowId(this.player), slot, this.getItem(slot)));
    }

    public void setItem(int slot, net.minecraft.server.v1_16_R3.ItemStack item) {
        if (slot < 2) {
            this.repairInventory.setItem(slot, item);
        } else {
            this.resultInventory.setItem(0, item);
        }
        if (this.open) {
            this.sendItem(slot);
        }
    }

    private net.minecraft.server.v1_16_R3.ItemStack getItem(int slot) {
        if (slot < 2) {
            return this.repairInventory.getItem(slot);
        }
        return this.resultInventory.getItem(0);
    }

    @Override
    public void setItem(int slot, ItemStack itemStack) {
        this.setItem(slot, CraftItemStack.asNMSCopy((ItemStack)itemStack));
    }

    @Override
    @NotNull
    public Inventory getBukkitInventory() {
        return this.view.getTopInventory();
    }

    @Override
    public String getRenameText() {
        return this.text;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    public CraftInventoryView getBukkitView() {
        return this.view;
    }

    public boolean canUse(EntityHuman entityhuman) {
        return true;
    }

    public void a(String s) {
        this.text = s;
        if (this.renameHandlers != null) {
            this.renameHandlers.forEach(handler -> handler.accept(s));
        }
        this.sendItem(2);
    }

    public void b(EntityHuman entityhuman) {
        this.open = false;
    }

    public void e() {
    }
}

