/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.invui.gui;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.invui.gui.AbstractPagedGui;
import xyz.xenondevs.invui.gui.PagedGui;
import xyz.xenondevs.invui.gui.SlotElement;
import xyz.xenondevs.invui.gui.structure.Structure;
import xyz.xenondevs.invui.item.Item;

final class PagedItemsGuiImpl
extends AbstractPagedGui<Item> {
    public PagedItemsGuiImpl(int width, int height, @Nullable List<@NotNull Item> items, int ... contentListSlots) {
        super(width, height, false, contentListSlots);
        this.setContent(items);
    }

    public PagedItemsGuiImpl(@Nullable List<@NotNull Item> items, @NotNull Structure structure) {
        super(structure.getWidth(), structure.getHeight(), false, structure);
        this.setContent(items);
    }

    @Override
    public void bake() {
        int contentSize = this.getContentListSlots().length;
        ArrayList pages = new ArrayList();
        ArrayList<SlotElement.ItemSlotElement> page = new ArrayList<SlotElement.ItemSlotElement>(contentSize);
        for (Item item : this.content) {
            page.add(new SlotElement.ItemSlotElement(item));
            if (page.size() < contentSize) continue;
            pages.add(page);
            page = new ArrayList(contentSize);
        }
        if (!page.isEmpty()) {
            pages.add(page);
        }
        this.pages = pages;
        this.update();
    }

    public static final class Builder
    extends AbstractPagedGui.AbstractBuilder<Item> {
        @Override
        @NotNull
        public PagedGui<Item> build() {
            if (this.structure == null) {
                throw new IllegalStateException("Structure is not defined.");
            }
            PagedItemsGuiImpl gui = new PagedItemsGuiImpl(this.content, this.structure);
            this.applyModifiers(gui);
            return gui;
        }
    }
}

