/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.invui.gui;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.gui.ScrollInventoryGuiImpl;
import xyz.xenondevs.invui.gui.ScrollItemsGuiImpl;
import xyz.xenondevs.invui.gui.ScrollNestedGuiImpl;
import xyz.xenondevs.invui.gui.structure.Structure;
import xyz.xenondevs.invui.inventory.Inventory;
import xyz.xenondevs.invui.item.Item;

public interface ScrollGui<C>
extends Gui {
    @NotNull
    public static @NotNull Builder<@NotNull Item> items() {
        return new ScrollItemsGuiImpl.Builder();
    }

    @NotNull
    public static @NotNull ScrollGui<@NotNull Item> items(@NotNull @NotNull Consumer<@NotNull Builder<@NotNull Item>> consumer) {
        Builder<Item> builder = ScrollGui.items();
        consumer.accept(builder);
        return (ScrollGui)builder.build();
    }

    @NotNull
    public static @NotNull ScrollGui<@NotNull Item> ofItems(int width, int height, @NotNull @NotNull List<@NotNull Item> items, int ... contentListSlots) {
        return new ScrollItemsGuiImpl(width, height, items, contentListSlots);
    }

    @NotNull
    public static @NotNull ScrollGui<@NotNull Item> ofItems(@NotNull Structure structure, @NotNull @NotNull List<@NotNull Item> items) {
        return new ScrollItemsGuiImpl(items, structure);
    }

    @NotNull
    public static @NotNull Builder<@NotNull Gui> guis() {
        return new ScrollNestedGuiImpl.Builder();
    }

    @NotNull
    public static @NotNull ScrollGui<@NotNull Gui> guis(@NotNull @NotNull Consumer<@NotNull Builder<@NotNull Gui>> consumer) {
        Builder<Gui> builder = ScrollGui.guis();
        consumer.accept(builder);
        return (ScrollGui)builder.build();
    }

    @NotNull
    public static @NotNull ScrollGui<@NotNull Gui> ofGuis(int width, int height, @NotNull @NotNull List<@NotNull Gui> guis, int ... contentListSlots) {
        return new ScrollNestedGuiImpl(width, height, guis, contentListSlots);
    }

    @NotNull
    public static @NotNull ScrollGui<@NotNull Gui> ofGuis(Structure structure, @NotNull @NotNull List<@NotNull Gui> guis) {
        return new ScrollNestedGuiImpl(guis, structure);
    }

    @NotNull
    public static @NotNull Builder<@NotNull Inventory> inventories() {
        return new ScrollInventoryGuiImpl.Builder();
    }

    @NotNull
    public static @NotNull ScrollGui<@NotNull Inventory> inventories(@NotNull @NotNull Consumer<@NotNull Builder<@NotNull Inventory>> consumer) {
        Builder<Inventory> builder = ScrollGui.inventories();
        consumer.accept(builder);
        return (ScrollGui)builder.build();
    }

    @NotNull
    public static @NotNull ScrollGui<@NotNull Inventory> ofInventories(int width, int height, @NotNull @NotNull List<@NotNull Inventory> inventories, int ... contentListSlots) {
        return new ScrollInventoryGuiImpl(width, height, inventories, contentListSlots);
    }

    @NotNull
    public static @NotNull ScrollGui<@NotNull Inventory> ofInventories(@NotNull Structure structure, @NotNull @NotNull List<@NotNull Inventory> inventories) {
        return new ScrollInventoryGuiImpl(inventories, structure);
    }

    public int getCurrentLine();

    public int getMaxLine();

    public void setCurrentLine(int var1);

    public boolean canScroll(int var1);

    public void scroll(int var1);

    public void setContent(@Nullable List<@NotNull C> var1);

    public void bake();

    public void setScrollHandlers(@NotNull @NotNull List<@NotNull BiConsumer<Integer, Integer>> var1);

    public void addScrollHandler(@NotNull BiConsumer<Integer, Integer> var1);

    public void removeScrollHandler(@NotNull BiConsumer<Integer, Integer> var1);

    public static interface Builder<C>
    extends Gui.Builder<ScrollGui<C>, Builder<C>> {
        @Contract(value="_ -> this")
        @NotNull
        public Builder<C> setContent(@NotNull @NotNull List<@NotNull C> var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder<C> addContent(@NotNull C var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder<C> setScrollHandlers(@NotNull @NotNull List<@NotNull BiConsumer<Integer, Integer>> var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder<C> addScrollHandler(@NotNull BiConsumer<Integer, Integer> var1);
    }
}

