/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.invui.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.invui.gui.AbstractTabGui;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.gui.SlotElement;
import xyz.xenondevs.invui.gui.TabGui;
import xyz.xenondevs.invui.gui.structure.Structure;

final class TabGuiImpl
extends AbstractTabGui {
    private final List<Gui> tabs;
    private final List<List<SlotElement>> linkingElements;

    public TabGuiImpl(int width, int height, @NotNull List<@Nullable Gui> tabs, int[] contentListSlots) {
        super(width, height, tabs.size(), contentListSlots);
        this.linkingElements = tabs.stream().map(this::getLinkingElements).collect(Collectors.toList());
        this.tabs = tabs;
        this.update();
    }

    public TabGuiImpl(@NotNull List<@Nullable Gui> tabs, @NotNull Structure structure) {
        super(structure.getWidth(), structure.getHeight(), tabs.size(), structure);
        this.linkingElements = tabs.stream().map(this::getLinkingElements).collect(Collectors.toList());
        this.tabs = tabs;
        this.update();
    }

    private List<SlotElement> getLinkingElements(Gui gui) {
        if (gui == null) {
            return null;
        }
        ArrayList<SlotElement> elements = new ArrayList<SlotElement>();
        for (int slot = 0; slot < gui.getSize(); ++slot) {
            SlotElement.LinkedSlotElement link = new SlotElement.LinkedSlotElement(gui, slot);
            elements.add(link);
        }
        return elements;
    }

    @Override
    public @NotNull List<@Nullable Gui> getTabs() {
        return Collections.unmodifiableList(this.tabs);
    }

    @Override
    public boolean isTabAvailable(int tab) {
        return this.tabs.size() > tab && this.tabs.get(tab) != null;
    }

    @Override
    protected List<SlotElement> getSlotElements(int tab) {
        return this.linkingElements.get(tab);
    }

    public static final class BuilderImpl
    extends AbstractTabGui.AbstractBuilder
    implements TabGui.Builder {
        @Override
        @NotNull
        public TabGui build() {
            if (this.structure == null) {
                throw new IllegalStateException("Structure is not defined.");
            }
            if (this.tabs == null) {
                throw new IllegalStateException("Tabs are not defined.");
            }
            TabGuiImpl gui = new TabGuiImpl(this.tabs, this.structure);
            this.applyModifiers(gui);
            return gui;
        }
    }
}

