/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.invui.gui.structure;

import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.invui.gui.SlotElement;
import xyz.xenondevs.invui.gui.structure.Marker;

class Ingredient {
    private final SlotElement slotElement;
    private final Marker marker;
    private final Supplier<? extends SlotElement> elementSupplier;

    public Ingredient(@NotNull SlotElement slotElement) {
        this.slotElement = slotElement;
        this.elementSupplier = null;
        this.marker = null;
    }

    public Ingredient(@NotNull Supplier<? extends SlotElement> elementSupplier) {
        this.elementSupplier = elementSupplier;
        this.slotElement = null;
        this.marker = null;
    }

    public Ingredient(@NotNull Marker marker) {
        this.marker = marker;
        this.slotElement = null;
        this.elementSupplier = null;
    }

    @Nullable
    public SlotElement getSlotElement() {
        return this.slotElement == null ? this.elementSupplier.get() : this.slotElement;
    }

    @Nullable
    public Marker getMarker() {
        return this.marker;
    }

    public boolean isSlotElement() {
        return this.slotElement != null || this.elementSupplier != null;
    }

    public boolean isMarker() {
        return this.marker != null;
    }
}

