/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.invui.inventory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.invui.InvUI;
import xyz.xenondevs.invui.inventory.VirtualInventory;

public class VirtualInventoryManager {
    private static final File SAVE_DIR = new File("plugins/InvUI/VirtualInventory/" + InvUI.getInstance().getPlugin().getName() + "/");
    private static VirtualInventoryManager instance;
    private final Map<UUID, VirtualInventory> inventories = new HashMap<UUID, VirtualInventory>();

    private VirtualInventoryManager() {
        InvUI.getInstance().addDisableHandler(this::serializeAll);
        this.deserializeAll();
    }

    public static VirtualInventoryManager getInstance() {
        return instance == null ? (instance = new VirtualInventoryManager()) : instance;
    }

    public VirtualInventory createNew(@NotNull UUID uuid, int size) {
        if (this.inventories.containsKey(uuid)) {
            throw new IllegalArgumentException("A VirtualInventory with that UUID already exists");
        }
        VirtualInventory inventory = new VirtualInventory(uuid, size);
        this.inventories.put(uuid, inventory);
        return inventory;
    }

    public VirtualInventory createNew(@NotNull UUID uuid, int size, ItemStack[] items, int[] stackSizes) {
        if (this.inventories.containsKey(uuid)) {
            throw new IllegalArgumentException("A Virtual Inventory with that UUID already exists");
        }
        VirtualInventory inventory = new VirtualInventory(uuid, size, items, stackSizes);
        this.inventories.put(uuid, inventory);
        return inventory;
    }

    public VirtualInventory getByUuid(@NotNull UUID uuid) {
        return this.inventories.get(uuid);
    }

    public VirtualInventory getOrCreate(UUID uuid, int size) {
        VirtualInventory inventory = this.getByUuid(uuid);
        return inventory == null ? this.createNew(uuid, size) : inventory;
    }

    public VirtualInventory getOrCreate(UUID uuid, int size, ItemStack[] items, int[] stackSizes) {
        VirtualInventory inventory = this.getByUuid(uuid);
        return inventory == null ? this.createNew(uuid, size, items, stackSizes) : inventory;
    }

    public List<VirtualInventory> getAllInventories() {
        return new ArrayList<VirtualInventory>(this.inventories.values());
    }

    public void remove(VirtualInventory inventory) {
        this.inventories.remove(inventory.getUuid(), inventory);
        this.getSaveFile(inventory).delete();
    }

    private void deserializeAll() {
        if (!SAVE_DIR.exists()) {
            return;
        }
        for (File file : SAVE_DIR.listFiles()) {
            if (!file.getName().endsWith(".vi2")) {
                return;
            }
            try (FileInputStream in = new FileInputStream(file);){
                VirtualInventory inventory = VirtualInventory.deserialize(in);
                this.inventories.put(inventory.getUuid(), inventory);
            }
            catch (IOException e) {
                InvUI.getInstance().getLogger().log(Level.SEVERE, "Failed to deserialize a VirtualInventory from file " + file.getPath(), e);
            }
        }
    }

    private void serializeAll() {
        if (this.inventories.isEmpty()) {
            return;
        }
        SAVE_DIR.mkdirs();
        for (VirtualInventory inventory : this.inventories.values()) {
            File file = this.getSaveFile(inventory);
            try (FileOutputStream out = new FileOutputStream(file);){
                inventory.serialize(out);
            }
            catch (IOException e) {
                InvUI.getInstance().getLogger().log(Level.SEVERE, "Failed to serialize a VirtualInventory to file " + file.getPath(), e);
            }
        }
    }

    private File getSaveFile(VirtualInventory inventory) {
        return new File(SAVE_DIR, String.valueOf(inventory.getUuid()) + ".vi2");
    }
}

