/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.invui.item.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.inventoryaccess.InventoryAccess;
import xyz.xenondevs.inventoryaccess.component.BungeeComponentWrapper;
import xyz.xenondevs.inventoryaccess.component.ComponentWrapper;
import xyz.xenondevs.invui.item.ItemProvider;
import xyz.xenondevs.invui.util.Pair;

public abstract class AbstractItemBuilder<S>
implements ItemProvider {
    protected ItemStack base;
    protected Material material;
    protected int amount = 1;
    protected int damage;
    protected int customModelData;
    protected Boolean unbreakable;
    protected ComponentWrapper displayName;
    protected List<ComponentWrapper> lore;
    protected List<ItemFlag> itemFlags;
    protected HashMap<Enchantment, Pair<Integer, Boolean>> enchantments;
    protected List<Function<ItemStack, ItemStack>> modifiers;

    public AbstractItemBuilder(@NotNull Material material) {
        this.material = material;
    }

    public AbstractItemBuilder(@NotNull Material material, int amount) {
        this.material = material;
        this.amount = amount;
    }

    public AbstractItemBuilder(@NotNull ItemStack base) {
        this.base = base.clone();
        this.amount = base.getAmount();
    }

    @Override
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public ItemStack get(@Nullable String lang) {
        ItemStack itemStack;
        if (this.base != null) {
            itemStack = this.base;
            itemStack.setAmount(this.amount);
        } else {
            itemStack = new ItemStack(this.material, this.amount);
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            if (this.displayName != null) {
                InventoryAccess.getItemUtils().setDisplayName(itemMeta, lang != null ? this.displayName.localized(lang) : this.displayName);
            }
            if (this.lore != null) {
                if (lang != null) {
                    List<ComponentWrapper> translatedLore = this.lore.stream().map(wrapper -> wrapper.localized(lang)).collect(Collectors.toList());
                    InventoryAccess.getItemUtils().setLore(itemMeta, translatedLore);
                } else {
                    InventoryAccess.getItemUtils().setLore(itemMeta, this.lore);
                }
            }
            if (itemMeta instanceof Damageable) {
                ((Damageable)itemMeta).setDamage(this.damage);
            }
            if (this.customModelData != 0) {
                itemMeta.setCustomModelData(Integer.valueOf(this.customModelData));
            }
            if (this.unbreakable != null) {
                itemMeta.setUnbreakable(this.unbreakable.booleanValue());
            }
            if (this.enchantments != null) {
                if (this.base != null) {
                    itemMeta.getEnchants().forEach((enchantment, level) -> itemMeta.removeEnchant(enchantment));
                }
                this.enchantments.forEach((enchantment, pair) -> itemMeta.addEnchant(enchantment, ((Integer)pair.getFirst()).intValue(), ((Boolean)pair.getSecond()).booleanValue()));
            }
            if (this.itemFlags != null) {
                if (this.base != null) {
                    itemMeta.removeItemFlags(itemMeta.getItemFlags().toArray(new ItemFlag[0]));
                }
                itemMeta.addItemFlags(this.itemFlags.toArray(new ItemFlag[0]));
            }
            itemStack.setItemMeta(itemMeta);
        }
        if (this.modifiers != null) {
            for (Function<ItemStack, ItemStack> modifier : this.modifiers) {
                itemStack = modifier.apply(itemStack);
            }
        }
        return itemStack;
    }

    @Contract(value="_ -> this")
    @NotNull
    public S removeLoreLine(int index) {
        if (this.lore != null) {
            this.lore.remove(index);
        }
        return (S)this;
    }

    @Contract(value="-> this")
    @NotNull
    public S clearLore() {
        if (this.lore != null) {
            this.lore.clear();
        }
        return (S)this;
    }

    @Nullable
    public ItemStack getBase() {
        return this.base;
    }

    @Nullable
    public Material getMaterial() {
        return this.material;
    }

    @Contract(value="_ -> this")
    @NotNull
    public S setMaterial(@NotNull Material material) {
        this.material = material;
        return (S)this;
    }

    public int getAmount() {
        return this.amount;
    }

    @Contract(value="_ -> this")
    @NotNull
    public S setAmount(int amount) {
        this.amount = amount;
        return (S)this;
    }

    public int getDamage() {
        return this.damage;
    }

    @Contract(value="_ -> this")
    @NotNull
    public S setDamage(int damage) {
        this.damage = damage;
        return (S)this;
    }

    public int getCustomModelData() {
        return this.customModelData;
    }

    @Contract(value="_ -> this")
    @NotNull
    public S setCustomModelData(int customModelData) {
        this.customModelData = customModelData;
        return (S)this;
    }

    @Nullable
    public Boolean isUnbreakable() {
        return this.unbreakable;
    }

    @Contract(value="_ -> this")
    @NotNull
    public S setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
        return (S)this;
    }

    @Nullable
    public ComponentWrapper getDisplayName() {
        return this.displayName;
    }

    @Contract(value="_ -> this")
    @NotNull
    public S setDisplayName(String displayName) {
        this.displayName = new BungeeComponentWrapper(TextComponent.fromLegacyText((String)displayName)).withoutPreFormatting();
        return (S)this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public S setDisplayName(BaseComponent ... displayName) {
        this.displayName = new BungeeComponentWrapper(displayName).withoutPreFormatting();
        return (S)this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public S setDisplayName(ComponentWrapper component) {
        this.displayName = component.withoutPreFormatting();
        return (S)this;
    }

    @Nullable
    public List<ComponentWrapper> getLore() {
        return this.lore;
    }

    @Contract(value="_ -> this")
    @NotNull
    public S setLore(@NotNull @NotNull List<@NotNull ComponentWrapper> lore) {
        this.lore = lore.stream().map(ComponentWrapper::withoutPreFormatting).collect(Collectors.toList());
        return (S)this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public S setLegacyLore(@NotNull @NotNull List<@NotNull String> lore) {
        this.lore = lore.stream().map(line -> new BungeeComponentWrapper(TextComponent.fromLegacyText((String)line)).withoutPreFormatting()).collect(Collectors.toList());
        return (S)this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public S addLoreLines(String ... lines) {
        if (this.lore == null) {
            this.lore = new ArrayList<ComponentWrapper>();
        }
        for (String line : lines) {
            this.lore.add(new BungeeComponentWrapper(TextComponent.fromLegacyText((String)line)).withoutPreFormatting());
        }
        return (S)this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public S addLoreLines(BaseComponent[] ... lines) {
        if (this.lore == null) {
            this.lore = new ArrayList<ComponentWrapper>();
        }
        for (BaseComponent[] line : lines) {
            this.lore.add(new BungeeComponentWrapper(line).withoutPreFormatting());
        }
        return (S)this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public S addLoreLines(ComponentWrapper ... lines) {
        if (this.lore == null) {
            this.lore = new ArrayList<ComponentWrapper>();
        }
        for (ComponentWrapper line : lines) {
            this.lore.add(line.withoutPreFormatting());
        }
        return (S)this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public S addLoreLines(@NotNull @NotNull List<@NotNull ComponentWrapper> lines) {
        if (this.lore == null) {
            this.lore = new ArrayList<ComponentWrapper>();
        }
        for (ComponentWrapper line : lines) {
            this.lore.add(line.withoutPreFormatting());
        }
        return (S)this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public S addLegacyLoreLines(@NotNull @NotNull List<@NotNull String> lines) {
        if (this.lore == null) {
            this.lore = new ArrayList<ComponentWrapper>();
        }
        for (String line : lines) {
            this.lore.add(new BungeeComponentWrapper(TextComponent.fromLegacyText((String)line)).withoutPreFormatting());
        }
        return (S)this;
    }

    @Nullable
    public List<ItemFlag> getItemFlags() {
        return this.itemFlags;
    }

    @Contract(value="_ -> this")
    @NotNull
    public S setItemFlags(@NotNull List<ItemFlag> itemFlags) {
        this.itemFlags = itemFlags;
        return (S)this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public S addItemFlags(ItemFlag ... itemFlags) {
        if (this.itemFlags == null) {
            this.itemFlags = new ArrayList<ItemFlag>();
        }
        this.itemFlags.addAll(Arrays.asList(itemFlags));
        return (S)this;
    }

    @Contract(value="-> this")
    @NotNull
    public S addAllItemFlags() {
        this.itemFlags = new ArrayList<ItemFlag>(Arrays.asList(ItemFlag.values()));
        return (S)this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public S removeItemFlags(ItemFlag ... itemFlags) {
        if (this.itemFlags != null) {
            this.itemFlags.removeAll(Arrays.asList(itemFlags));
        }
        return (S)this;
    }

    @Contract(value="-> this")
    @NotNull
    public S clearItemFlags() {
        if (this.itemFlags != null) {
            this.itemFlags.clear();
        }
        return (S)this;
    }

    @Nullable
    public HashMap<Enchantment, Pair<Integer, Boolean>> getEnchantments() {
        return this.enchantments;
    }

    @Contract(value="_ -> this")
    @NotNull
    public S setEnchantments(@NotNull HashMap<Enchantment, Pair<Integer, Boolean>> enchantments) {
        this.enchantments = enchantments;
        return (S)this;
    }

    @Contract(value="_, _, _ -> this")
    @NotNull
    public S addEnchantment(Enchantment enchantment, int level, boolean ignoreLevelRestriction) {
        if (this.enchantments == null) {
            this.enchantments = new HashMap();
        }
        this.enchantments.put(enchantment, new Pair<Integer, Boolean>(level, ignoreLevelRestriction));
        return (S)this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public S removeEnchantment(Enchantment enchantment) {
        if (this.enchantments != null) {
            this.enchantments.remove(enchantment);
        }
        return (S)this;
    }

    @Contract(value="-> this")
    @NotNull
    public S clearEnchantments() {
        if (this.enchantments != null) {
            this.enchantments.clear();
        }
        return (S)this;
    }

    @Nullable
    public List<Function<ItemStack, ItemStack>> getModifiers() {
        return this.modifiers;
    }

    @Contract(value="_ -> this")
    @NotNull
    public S addModifier(Function<ItemStack, ItemStack> modifier) {
        if (this.modifiers == null) {
            this.modifiers = new ArrayList<Function<ItemStack, ItemStack>>();
        }
        this.modifiers.add(modifier);
        return (S)this;
    }

    @Contract(value="-> this")
    @NotNull
    public S clearModifiers() {
        if (this.modifiers != null) {
            this.modifiers.clear();
        }
        return (S)this;
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public S clone() {
        try {
            AbstractItemBuilder clone = (AbstractItemBuilder)super.clone();
            if (this.base != null) {
                clone.base = this.base.clone();
            }
            if (this.lore != null) {
                clone.lore = new ArrayList<ComponentWrapper>(this.lore);
            }
            if (this.itemFlags != null) {
                clone.itemFlags = new ArrayList<ItemFlag>(this.itemFlags);
            }
            if (this.enchantments != null) {
                clone.enchantments = new HashMap<Enchantment, Pair<Integer, Boolean>>(this.enchantments);
            }
            if (this.modifiers != null) {
                clone.modifiers = new ArrayList<Function<ItemStack, ItemStack>>(this.modifiers);
            }
            return (S)clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

